/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.LoadRecentBranchRevisions;
import org.jetbrains.idea.svn.integrate.MergeCalculatorTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.ShowRecentInDialogTask;

public class MergeAllOrSelectedChooserTask
extends BaseMergeTask {
    public MergeAllOrSelectedChooserTask(@NotNull MergeContext mergeContext, @NotNull QuickMergeInteraction interaction) {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/MergeAllOrSelectedChooserTask", "<init>"));
        }
        if (interaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interaction", "org/jetbrains/idea/svn/integrate/MergeAllOrSelectedChooserTask", "<init>"));
        }
        super(mergeContext, interaction, "merge source selector", Where.AWT);
    }

    public void run(ContinuationContext context) {
        switch (this.myInteraction.selectMergeVariant()) {
            case all: {
                context.next(this.getMergeAllTasks());
                break;
            }
            case showLatest: {
                LoadRecentBranchRevisions loader = new LoadRecentBranchRevisions(this.myMergeContext, -1L);
                ShowRecentInDialogTask dialog = new ShowRecentInDialogTask(this.myMergeContext, this.myInteraction, loader);
                context.next(new TaskDescriptor[]{loader, dialog});
                break;
            }
            case select: {
                MergeCalculatorTask calculator = this.getMergeCalculatorTask(context);
                if (calculator == null) break;
                context.next(new TaskDescriptor[]{this.getCalculateFirstCopyPointTask(calculator), calculator});
            }
        }
    }

    @NotNull
    private TaskDescriptor getCalculateFirstCopyPointTask(@NotNull MergeCalculatorTask mergeCalculator) {
        if (mergeCalculator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeCalculator", "org/jetbrains/idea/svn/integrate/MergeAllOrSelectedChooserTask", "getCalculateFirstCopyPointTask"));
        }
        TaskDescriptor taskDescriptor = this.myMergeContext.getVcs().getSvnBranchPointsCalculator().getFirstCopyPointTask(this.myMergeContext.getWcInfo().getRepositoryRoot(), this.myMergeContext.getWcInfo().getRootUrl(), this.myMergeContext.getSourceUrl(), mergeCalculator);
        if (taskDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeAllOrSelectedChooserTask", "getCalculateFirstCopyPointTask"));
        }
        return taskDescriptor;
    }

    @Nullable
    private MergeCalculatorTask getMergeCalculatorTask(@NotNull ContinuationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/integrate/MergeAllOrSelectedChooserTask", "getMergeCalculatorTask"));
        }
        MergeCalculatorTask result = null;
        try {
            result = new MergeCalculatorTask(this.myMergeContext, this.myInteraction);
        }
        catch (VcsException e) {
            this.finishWithError(context, e.getMessage(), true);
        }
        return result;
    }
}

