/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder;

import java.io.IOException;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.transcoder.AbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.DOMImplementationKey;
import org.apache.batik.transcoder.keys.StringKey;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public abstract class XMLAbstractTranscoder
extends AbstractTranscoder {
    public static final TranscodingHints.Key KEY_XML_PARSER_CLASSNAME = new StringKey();
    public static final TranscodingHints.Key KEY_XML_PARSER_VALIDATING = new BooleanKey();
    public static final TranscodingHints.Key KEY_DOCUMENT_ELEMENT = new StringKey();
    public static final TranscodingHints.Key KEY_DOCUMENT_ELEMENT_NAMESPACE_URI = new StringKey();
    public static final TranscodingHints.Key KEY_DOM_IMPLEMENTATION = new DOMImplementationKey();

    protected XMLAbstractTranscoder() {
        this.hints.put(KEY_XML_PARSER_VALIDATING, Boolean.FALSE);
    }

    @Override
    public void transcode(TranscoderInput transcoderInput, TranscoderOutput transcoderOutput) throws TranscoderException {
        Document document = null;
        String string = transcoderInput.getURI();
        if (transcoderInput.getDocument() != null) {
            document = transcoderInput.getDocument();
        } else {
            String string2 = (String)this.hints.get(KEY_XML_PARSER_CLASSNAME);
            String string3 = (String)this.hints.get(KEY_DOCUMENT_ELEMENT_NAMESPACE_URI);
            String string4 = (String)this.hints.get(KEY_DOCUMENT_ELEMENT);
            DOMImplementation dOMImplementation = (DOMImplementation)this.hints.get(KEY_DOM_IMPLEMENTATION);
            if (string2 == null) {
                string2 = XMLResourceDescriptor.getXMLParserClassName();
            }
            if (dOMImplementation == null) {
                this.handler.fatalError(new TranscoderException("Unspecified transcoding hints: KEY_DOM_IMPLEMENTATION"));
                return;
            }
            if (string3 == null) {
                this.handler.fatalError(new TranscoderException("Unspecified transcoding hints: KEY_DOCUMENT_ELEMENT_NAMESPACE_URI"));
                return;
            }
            if (string4 == null) {
                this.handler.fatalError(new TranscoderException("Unspecified transcoding hints: KEY_DOCUMENT_ELEMENT"));
                return;
            }
            DocumentFactory documentFactory = this.createDocumentFactory(dOMImplementation, string2);
            boolean bl = (Boolean)this.hints.get(KEY_XML_PARSER_VALIDATING);
            documentFactory.setValidating(bl);
            try {
                if (transcoderInput.getInputStream() != null) {
                    document = documentFactory.createDocument(string3, string4, transcoderInput.getURI(), transcoderInput.getInputStream());
                } else if (transcoderInput.getReader() != null) {
                    document = documentFactory.createDocument(string3, string4, transcoderInput.getURI(), transcoderInput.getReader());
                } else if (transcoderInput.getXMLReader() != null) {
                    document = documentFactory.createDocument(string3, string4, transcoderInput.getURI(), transcoderInput.getXMLReader());
                } else if (string != null) {
                    document = documentFactory.createDocument(string3, string4, string);
                }
            }
            catch (DOMException dOMException) {
                this.handler.fatalError(new TranscoderException(dOMException));
            }
            catch (IOException iOException) {
                this.handler.fatalError(new TranscoderException(iOException));
            }
        }
        if (document != null) {
            try {
                this.transcode(document, string, transcoderOutput);
            }
            catch (TranscoderException transcoderException) {
                this.handler.fatalError(transcoderException);
                return;
            }
        }
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation dOMImplementation, String string) {
        return new SAXDocumentFactory(dOMImplementation, string);
    }

    protected abstract void transcode(Document var1, String var2, TranscoderOutput var3) throws TranscoderException;
}

