/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.plugincomponents;

import com.intellij.AppTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBus;
import org.editorconfig.configmanagement.EditorSettingsManager;
import org.editorconfig.configmanagement.EncodingManager;
import org.editorconfig.configmanagement.LineEndingsManager;
import org.jetbrains.annotations.NotNull;

public class ConfigProjectComponent
implements ProjectComponent {
    public ConfigProjectComponent(Project project, final EditorFactory editorFactory) {
        MessageBus bus = project.getMessageBus();
        EditorSettingsManager editorSettingsManager = new EditorSettingsManager(project);
        EncodingManager encodingManager = new EncodingManager(project);
        LineEndingsManager lineEndingsManager = new LineEndingsManager(project);
        bus.connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)encodingManager);
        bus.connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)editorSettingsManager);
        bus.connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)lineEndingsManager);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/editorconfig/plugincomponents/ConfigProjectComponent$1", "fileCreated"));
                }
                this.updateOpenEditors(event);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/editorconfig/plugincomponents/ConfigProjectComponent$1", "fileDeleted"));
                }
                this.updateOpenEditors(event);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/editorconfig/plugincomponents/ConfigProjectComponent$1", "contentsChanged"));
                }
                this.updateOpenEditors(event);
            }

            private void updateOpenEditors(VirtualFileEvent event) {
                if (".editorconfig".equals(event.getFile().getName())) {
                    for (Editor editor : editorFactory.getAllEditors()) {
                        ((EditorEx)editor).reinitSettings();
                    }
                }
            }
        }, (Disposable)project);
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("ConfigProjectComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/editorconfig/plugincomponents/ConfigProjectComponent", "getComponentName"));
        }
        return "ConfigProjectComponent";
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }
}

