/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.FeedbackLayer;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.VertInsertFeedbackPainter;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.Nullable;

public class FlowDropLocation
implements ComponentDropLocation {
    private int myInsertIndex;
    private final String myInsertBeforeId;
    private final RadContainer myContainer;
    private final int myAlignment;
    private final int myHGap;
    private final int myVGap;

    public FlowDropLocation(RadContainer container, Point location, @JdkConstants.FlowLayoutAlignment int alignment, int hGap, int vGap) {
        this.myContainer = container;
        this.myAlignment = alignment;
        this.myHGap = hGap;
        this.myVGap = vGap;
        this.myInsertIndex = this.myContainer.getComponentCount();
        if (location != null) {
            for (int i = 0; i < this.myContainer.getComponentCount(); ++i) {
                Rectangle bounds = this.myContainer.getComponent(i).getBounds();
                bounds.grow(this.myHGap, vGap);
                if (bounds.contains(location)) {
                    if ((double)location.x < bounds.getCenterX()) {
                        this.myInsertIndex = i;
                        break;
                    }
                    this.myInsertIndex = i + 1;
                    break;
                }
                if (i != 0 || location.x >= bounds.x) continue;
                this.myInsertIndex = 0;
            }
        }
        this.myInsertBeforeId = this.myInsertIndex < this.myContainer.getComponentCount() ? this.myContainer.getComponent(this.myInsertIndex).getId() : null;
    }

    @Override
    public RadContainer getContainer() {
        return this.myContainer;
    }

    @Override
    public boolean canDrop(ComponentDragObject dragObject) {
        return true;
    }

    @Override
    public void placeFeedback(FeedbackLayer feedbackLayer, ComponentDragObject dragObject) {
        if (this.myContainer.getComponentCount() == 0) {
            Dimension initialSize = dragObject.getInitialSize(this.getContainer());
            int originX = this.myAlignment == 1 ? this.myContainer.getSize().width / 2 - initialSize.width / 2 - this.myHGap : (this.isRightAlign() ? this.myContainer.getSize().width - initialSize.width - 2 * this.myHGap : 2 * this.myHGap);
            int height = Math.min(initialSize.height, this.myContainer.getBounds().height);
            Rectangle rc = new Rectangle(originX, 2 * this.myVGap, initialSize.width, height);
            feedbackLayer.putFeedback(this.myContainer.getDelegee(), rc, this.myContainer.getDisplayName());
        } else if (this.myInsertIndex == this.myContainer.getComponentCount() && !this.isRightAlign() || this.myInsertIndex == 0 && !this.isLeftAlign()) {
            Rectangle rc;
            Dimension initialSize = dragObject.getInitialSize(this.getContainer());
            JComponent component = this.myContainer.getDelegee();
            int minX = component.getComponent((int)0).getBounds().x;
            int maxX = 0;
            int maxSize = 0;
            int lastTop = this.myContainer.getDelegee().getInsets().top;
            for (Component child : component.getComponents()) {
                int childX = child.getBounds().x + child.getBounds().width;
                if (childX > maxX) {
                    maxX = childX;
                }
                maxSize = Math.max(maxSize, child.getBounds().height);
                lastTop = child.getBounds().y;
            }
            maxSize = Math.max(maxSize, initialSize.height);
            maxSize = Math.min(maxSize, this.myContainer.getBounds().height);
            if (this.myInsertIndex == 0) {
                rc = new Rectangle(minX - this.myHGap - initialSize.width, lastTop, initialSize.width, maxSize);
            } else {
                int initialWidth = Math.max(8, Math.min(initialSize.width, this.myContainer.getBounds().width - maxX));
                rc = new Rectangle(maxX, lastTop, initialWidth, maxSize);
            }
            feedbackLayer.putFeedback(this.myContainer.getDelegee(), rc, this.myContainer.getDisplayName());
        } else if (this.myInsertIndex == this.myContainer.getComponentCount() && this.isRightAlign()) {
            Rectangle bounds = this.myContainer.getComponent(this.myInsertIndex - 1).getBounds();
            Rectangle rc = new Rectangle(bounds.x + bounds.width, bounds.y, 8, bounds.height);
            feedbackLayer.putFeedback(this.myContainer.getDelegee(), rc, VertInsertFeedbackPainter.INSTANCE, this.myContainer.getDisplayName());
        } else {
            Rectangle bounds = this.myContainer.getComponent(this.myInsertIndex).getBounds();
            Rectangle rc = new Rectangle(bounds.x - 4 - this.myHGap, bounds.y, 8, bounds.height);
            feedbackLayer.putFeedback(this.myContainer.getDelegee(), rc, VertInsertFeedbackPainter.INSTANCE, this.myContainer.getDisplayName());
        }
    }

    private boolean isLeftAlign() {
        return this.myAlignment == 0 || this.myAlignment == 3;
    }

    private boolean isRightAlign() {
        return this.myAlignment == 2 || this.myAlignment == 4;
    }

    @Override
    public void processDrop(GuiEditor editor, RadComponent[] components, GridConstraints[] constraintsToAdjust, ComponentDragObject dragObject) {
        for (int i = 0; i < this.myContainer.getComponentCount(); ++i) {
            if (!this.myContainer.getComponent(i).getId().equals(this.myInsertBeforeId)) continue;
            this.myInsertIndex = i;
            break;
        }
        if (this.myInsertIndex > this.myContainer.getComponentCount()) {
            this.myInsertIndex = this.myContainer.getComponentCount();
        }
        for (RadComponent component : components) {
            this.myContainer.addComponent(component, this.myInsertIndex);
            ++this.myInsertIndex;
        }
    }

    @Override
    @Nullable
    public ComponentDropLocation getAdjacentLocation(ComponentDropLocation.Direction direction) {
        return null;
    }
}

