/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.actions.DeleteAction;
import com.intellij.uiDesigner.actions.InsertAfterAction;
import com.intellij.uiDesigner.actions.InsertBeforeAction;
import com.intellij.uiDesigner.actions.SplitAction;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.properties.HGapProperty;
import com.intellij.uiDesigner.propertyInspector.properties.HSizePolicyProperty;
import com.intellij.uiDesigner.propertyInspector.properties.HorzAlignProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IndentProperty;
import com.intellij.uiDesigner.propertyInspector.properties.MarginProperty;
import com.intellij.uiDesigner.propertyInspector.properties.MaximumSizeProperty;
import com.intellij.uiDesigner.propertyInspector.properties.MinimumSizeProperty;
import com.intellij.uiDesigner.propertyInspector.properties.PreferredSizeProperty;
import com.intellij.uiDesigner.propertyInspector.properties.SameSizeHorizontallyProperty;
import com.intellij.uiDesigner.propertyInspector.properties.SameSizeVerticallyProperty;
import com.intellij.uiDesigner.propertyInspector.properties.UseParentLayoutProperty;
import com.intellij.uiDesigner.propertyInspector.properties.VGapProperty;
import com.intellij.uiDesigner.propertyInspector.properties.VSizePolicyProperty;
import com.intellij.uiDesigner.propertyInspector.properties.VertAlignProperty;
import com.intellij.uiDesigner.radComponents.CustomPropertiesPanel;
import com.intellij.uiDesigner.radComponents.GridLayoutColumnProperties;
import com.intellij.uiDesigner.radComponents.RadAbstractGridLayoutManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadXYLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;

public class RadGridLayoutManager
extends RadAbstractGridLayoutManager {
    private GridLayoutColumnProperties myPropertiesPanel;

    @Override
    public String getName() {
        return "GridLayoutManager";
    }

    @Override
    public LayoutManager createLayout() {
        return new GridLayoutManager(1, 1);
    }

    @Override
    protected void changeLayoutFromGrid(RadContainer container, List<RadComponent> contents, List<Boolean> canRowsGrow, List<Boolean> canColumnsGrow) {
        int rowCount = Math.max(1, canRowsGrow.size());
        int columnCount = Math.max(1, canColumnsGrow.size());
        container.setLayoutManager(this, (LayoutManager)new GridLayoutManager(rowCount, columnCount));
    }

    @Override
    protected void changeLayoutFromIndexed(RadContainer container, List<RadComponent> components) {
        container.setLayoutManager(this, (LayoutManager)new GridLayoutManager(1, Math.max(1, components.size())));
    }

    @Override
    public void writeLayout(XmlWriter writer, RadContainer radContainer) {
        GridLayoutManager layout = (GridLayoutManager)radContainer.getLayout();
        writer.addAttribute("row-count", layout.getRowCount());
        writer.addAttribute("column-count", layout.getColumnCount());
        writer.addAttribute("same-size-horizontally", layout.isSameSizeHorizontally());
        writer.addAttribute("same-size-vertically", layout.isSameSizeVertically());
        RadXYLayoutManager.INSTANCE.writeLayout(writer, radContainer);
    }

    @Override
    public void addComponentToContainer(RadContainer container, RadComponent component, int index) {
        super.addComponentToContainer(container, component, index);
        container.getDelegee().add((Component)component.getDelegee(), component.getConstraints());
    }

    @Override
    protected void updateConstraints(RadComponent component) {
        GridConstraints delegeeConstraints;
        GridLayoutManager layout = (GridLayoutManager)component.getParent().getLayout();
        GridConstraints radConstraints = component.getConstraints();
        if (radConstraints != (delegeeConstraints = layout.getConstraintsForComponent((Component)component.getDelegee()))) {
            delegeeConstraints.restore(radConstraints);
        }
        super.updateConstraints(component);
    }

    @Override
    public void writeChildConstraints(XmlWriter writer, RadComponent child) {
        RadGridLayoutManager.writeGridConstraints(writer, child);
    }

    @Override
    public Property[] getContainerProperties(Project project) {
        return new Property[]{MarginProperty.getInstance(project), HGapProperty.getInstance(project), VGapProperty.getInstance(project), SameSizeHorizontallyProperty.getInstance(project), SameSizeVerticallyProperty.getInstance(project)};
    }

    @Override
    public Property[] getComponentProperties(Project project, RadComponent component) {
        return new Property[]{HSizePolicyProperty.getInstance(project), VSizePolicyProperty.getInstance(project), HorzAlignProperty.getInstance(project), VertAlignProperty.getInstance(project), IndentProperty.getInstance(project), UseParentLayoutProperty.getInstance(project), MinimumSizeProperty.getInstance(project), PreferredSizeProperty.getInstance(project), MaximumSizeProperty.getInstance(project)};
    }

    @Override
    public int getGridRowCount(RadContainer container) {
        return ((GridLayoutManager)container.getLayout()).getRowCount();
    }

    @Override
    public int getGridColumnCount(RadContainer container) {
        return ((GridLayoutManager)container.getLayout()).getColumnCount();
    }

    @Override
    public int[] getHorizontalGridLines(RadContainer container) {
        GridLayoutManager grid = (GridLayoutManager)container.getLayout();
        return grid.getHorizontalGridLines();
    }

    @Override
    public int[] getVerticalGridLines(RadContainer container) {
        GridLayoutManager grid = (GridLayoutManager)container.getLayout();
        return grid.getVerticalGridLines();
    }

    @Override
    public int[] getGridCellCoords(RadContainer container, boolean isRow) {
        GridLayoutManager grid = (GridLayoutManager)container.getLayout();
        return isRow ? grid.getYs() : grid.getXs();
    }

    @Override
    public int[] getGridCellSizes(RadContainer container, boolean isRow) {
        GridLayoutManager grid = (GridLayoutManager)container.getLayout();
        return isRow ? grid.getHeights() : grid.getWidths();
    }

    @Override
    public CustomPropertiesPanel getRowColumnPropertiesPanel(RadContainer container, boolean isRow, int[] selectedIndices) {
        if (this.myPropertiesPanel == null) {
            this.myPropertiesPanel = new GridLayoutColumnProperties();
        }
        this.myPropertiesPanel.showProperties(container, isRow, selectedIndices);
        return this.myPropertiesPanel;
    }

    @Override
    public ActionGroup getCaptionActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new InsertBeforeAction());
        group.add((AnAction)new InsertAfterAction());
        group.add((AnAction)new SplitAction());
        group.add((AnAction)new DeleteAction());
        return group;
    }

    @Override
    public boolean canCellGrow(RadContainer container, boolean isRow, int cellIndex) {
        GridLayoutManager gridLayoutManager = (GridLayoutManager)container.getLayout();
        int maxSizePolicy = 0;
        for (int i = 0; i < gridLayoutManager.getCellCount(isRow); ++i) {
            maxSizePolicy = Math.max(maxSizePolicy, gridLayoutManager.getCellSizePolicy(isRow, i));
        }
        return gridLayoutManager.getCellSizePolicy(isRow, cellIndex) == maxSizePolicy;
    }

    @Override
    public void processCellResized(RadContainer container, boolean isRow, int cell, int newSize) {
        int cellCount;
        int n = cellCount = isRow ? container.getGridRowCount() : container.getGridColumnCount();
        if (container.getParent().isXY() && cell == cellCount - 1) {
            RadGridLayoutManager.processRootContainerResize(container, isRow, newSize);
        } else {
            for (RadComponent component : container.getComponents()) {
                GridConstraints c = component.getConstraints();
                if (c.getCell(isRow) != cell || c.getSpan(isRow) != 1) continue;
                Dimension preferredSize = new Dimension(c.myPreferredSize);
                if (isRow) {
                    preferredSize.height = newSize;
                    if (preferredSize.width == -1) {
                        preferredSize.width = component.getDelegee().getPreferredSize().width;
                    }
                } else {
                    preferredSize.width = newSize;
                    if (preferredSize.height == -1) {
                        preferredSize.height = component.getDelegee().getPreferredSize().height;
                    }
                }
                PreferredSizeProperty.getInstance(container.getProject()).setValueEx(component, preferredSize);
            }
        }
    }

    private static void processRootContainerResize(RadContainer container, boolean isRow, int newSize) {
        JComponent parentDelegee = container.getDelegee();
        Dimension containerSize = parentDelegee.getSize();
        if (isRow) {
            containerSize.height = newSize + parentDelegee.getBounds().y;
        } else {
            containerSize.width = newSize + parentDelegee.getBounds().x;
        }
        parentDelegee.setSize(containerSize);
        parentDelegee.revalidate();
    }

    @Override
    public void copyGridSection(RadContainer source, RadContainer destination, Rectangle rc) {
        destination.setLayout((LayoutManager)new GridLayoutManager(rc.height, rc.width));
    }

    @Override
    public LayoutManager copyLayout(LayoutManager layout, int rowDelta, int columnDelta) {
        GridLayoutManager oldLayout = (GridLayoutManager)layout;
        GridLayoutManager newLayout = new GridLayoutManager(oldLayout.getRowCount() + rowDelta, oldLayout.getColumnCount() + columnDelta);
        newLayout.setMargin(oldLayout.getMargin());
        newLayout.setHGap(oldLayout.getHGap());
        newLayout.setVGap(oldLayout.getVGap());
        return newLayout;
    }
}

