/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.snapShooter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.uiDesigner.snapShooter.SnapShotRemoteComponent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

public class SnapShotClient {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.snapShooter.SnapShotClient");
    private Socket mySocket;
    @NonNls
    private BufferedReader myReader;
    @NonNls
    private OutputStreamWriter myWriter;
    private boolean myDisconnected;
    @NonNls
    private static final String FORM_POSTFIX = "</form>";

    public void connect(int port) throws IOException {
        this.mySocket = new Socket(InetAddress.getLocalHost(), port);
        this.mySocket.setSoTimeout(10000);
        this.myReader = new BufferedReader(new InputStreamReader(this.mySocket.getInputStream(), CharsetToolkit.UTF8_CHARSET));
        this.myWriter = new OutputStreamWriter(this.mySocket.getOutputStream(), CharsetToolkit.UTF8_CHARSET);
    }

    public void dispose() {
        try {
            this.myWriter.close();
            this.myReader.close();
            this.mySocket.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void suspendSwing() throws IOException {
        this.myWriter.write("S\n");
        this.myWriter.flush();
    }

    public void resumeSwing() throws IOException {
        this.myWriter.write("R\n");
        this.myWriter.flush();
    }

    public SnapShotRemoteComponent[] listChildren(int id) throws IOException {
        if (this.myDisconnected) {
            return new SnapShotRemoteComponent[0];
        }
        ArrayList<SnapShotRemoteComponent> result = new ArrayList<SnapShotRemoteComponent>();
        this.myWriter.write("L" + Integer.toString(id) + "\n");
        this.myWriter.flush();
        while (true) {
            String line;
            if ((line = this.myReader.readLine()) == null) {
                throw new IOException("SnapShooter disconnected");
            }
            if (line.trim().equals(".")) break;
            result.add(new SnapShotRemoteComponent(line, id == 0));
        }
        return result.toArray(new SnapShotRemoteComponent[result.size()]);
    }

    public String createSnapshot(int id) throws Exception {
        String line;
        this.myWriter.write("X" + id + "\n");
        this.myWriter.flush();
        StringBuilder result = new StringBuilder();
        do {
            if ((line = this.myReader.readLine()) == null) {
                throw new IOException("SnapShooter disconnected");
            }
            if (result.length() == 0 && line.startsWith("E:")) {
                throw new Exception(line.substring(2));
            }
            result.append(line).append("\n");
        } while (!line.trim().endsWith(FORM_POSTFIX));
        return result.toString();
    }

    public void setDisconnected() {
        this.myDisconnected = true;
    }
}

