/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionBinder;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class UnboundFunctionLibrary
implements FunctionLibrary {
    private List unboundFunctionCalls = new ArrayList(20);
    private List correspondingStaticContext = new ArrayList(20);
    private boolean resolving = false;

    public SequenceType[] getFunctionSignature(StructuredQName functionName, int arity) {
        return null;
    }

    public Expression bind(StructuredQName functionName, Expression[] arguments, StaticContext env, Container container) throws XPathException {
        if (this.resolving) {
            return null;
        }
        UserFunctionCall ufc = new UserFunctionCall();
        ufc.setFunctionName(functionName);
        ufc.setArguments(arguments);
        this.unboundFunctionCalls.add(ufc);
        this.correspondingStaticContext.add(env);
        return ufc;
    }

    public void bindUnboundFunctionCalls(XQueryFunctionBinder lib, Configuration config) throws XPathException {
        this.resolving = true;
        for (int i = 0; i < this.unboundFunctionCalls.size(); ++i) {
            UserFunctionCall ufc = (UserFunctionCall)this.unboundFunctionCalls.get(i);
            QueryModule importingModule = (QueryModule)this.correspondingStaticContext.get(i);
            this.correspondingStaticContext.set(i, null);
            StructuredQName q = ufc.getFunctionName();
            int arity = ufc.getNumberOfArguments();
            XQueryFunction fd = lib.getDeclaration(q, ufc.getArguments());
            if (fd == null) {
                String msg = "Cannot find a matching " + arity + "-argument function named " + q.getClarkName() + "()";
                if (!config.isAllowExternalFunctions()) {
                    msg = msg + ". Note: external function calls have been disabled";
                }
                XPathException err = new XPathException(msg, ufc);
                err.setErrorCode("XPST0017");
                err.setIsStaticError(true);
                throw err;
            }
            fd.registerReference(ufc);
            ufc.setStaticType(fd.getResultType());
            importingModule.checkImportedFunctionSignature(fd);
        }
    }

    public FunctionLibrary copy() {
        UnboundFunctionLibrary qfl = new UnboundFunctionLibrary();
        qfl.unboundFunctionCalls = new ArrayList(this.unboundFunctionCalls);
        qfl.correspondingStaticContext = new ArrayList(this.correspondingStaticContext);
        return qfl;
    }
}

