/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

public enum ScreenRatio implements ResourceEnum
{
    NOTLONG("notlong", "Not Long", "Short screen aspect ratio"),
    LONG("long", "Long", "Long screen aspect ratio");

    private final String mValue;
    private final String mShortDisplayValue;
    private final String mLongDisplayValue;

    private ScreenRatio(String value, String displayValue, String longDisplayValue) {
        this.mValue = value;
        this.mShortDisplayValue = displayValue;
        this.mLongDisplayValue = longDisplayValue;
    }

    public static ScreenRatio getEnum(String value) {
        for (ScreenRatio orient : ScreenRatio.values()) {
            if (!orient.mValue.equals(value)) continue;
            return orient;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mShortDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mLongDisplayValue;
    }

    public static int getIndex(ScreenRatio orientation) {
        int i = 0;
        for (ScreenRatio orient : ScreenRatio.values()) {
            if (orient == orientation) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static ScreenRatio getByIndex(int index) {
        ScreenRatio[] values = ScreenRatio.values();
        if (index >= 0 && index < values.length) {
            return values[index];
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return true;
    }
}

