/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.jql.JqlLanguage;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class JiraRepositoryEditor
extends BaseRepositoryEditor<JiraRepository> {
    private EditorTextField mySearchQueryField;
    private JBLabel mySearchLabel;
    private JBLabel myNoteLabel;

    public JiraRepositoryEditor(Project project, JiraRepository repository, Consumer<JiraRepository> changeListener) {
        super(project, (BaseRepository)repository, changeListener);
    }

    public void apply() {
        ((JiraRepository)this.myRepository).setSearchQuery(this.mySearchQueryField.getText());
        super.apply();
        this.enableJqlSearchIfSupported();
    }

    protected void afterTestConnection(boolean connectionSuccessful) {
        super.afterTestConnection(connectionSuccessful);
        if (connectionSuccessful) {
            this.enableJqlSearchIfSupported();
        }
        this.updateNote();
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.mySearchQueryField = new LanguageTextField((Language)JqlLanguage.INSTANCE, this.myProject, ((JiraRepository)this.myRepository).getSearchQuery());
        this.enableJqlSearchIfSupported();
        this.installListener(this.mySearchQueryField);
        this.mySearchLabel = new JBLabel("Search:", 4);
        this.myNoteLabel = new JBLabel();
        this.myNoteLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.updateNote();
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.mySearchLabel, (JComponent)this.mySearchQueryField).addComponentToRightColumn((JComponent)this.myNoteLabel).getPanel();
    }

    private void updateNote() {
        this.myNoteLabel.setText("JQL search cannot be used in JIRA versions prior 4.2. " + String.format("Your version: %s.", StringUtil.notNullize((String)((JiraRepository)this.myRepository).getJiraVersion(), (String)"unknown")));
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.mySearchLabel.setAnchor(anchor);
    }

    private void enableJqlSearchIfSupported() {
        this.mySearchQueryField.setEnabled(((JiraRepository)this.myRepository).isJqlSupported());
    }
}

