/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsImport;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.connections.CvsRootProvider;
import com.intellij.cvsSupport2.cvsoperations.common.CvsCommandOperation;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.cvsImport.ImportDetails;
import com.intellij.cvsSupport2.ui.experts.importToCvs.FileExtension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.importcmd.ImportCommand;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.util.IIgnoreFileFilter;

public class ImportOperation
extends CvsCommandOperation {
    private final ImportDetails myDetails;

    public ImportOperation(ImportDetails details) {
        this.myDetails = details;
    }

    @Override
    protected Collection<CvsRootProvider> getAllCvsRoots() {
        return Collections.singleton(this.myDetails.getCvsRoot());
    }

    @Override
    protected Command createCommand(CvsRootProvider root, CvsExecutionEnvironment cvsExecutionEnvironment) {
        ImportCommand result = new ImportCommand();
        this.myDetails.prepareCommand(result);
        return result;
    }

    public static ImportOperation createTestInstance(File sourceLocation, CvsEnvironment env) {
        ImportDetails details = new ImportDetails(sourceLocation, CvsBundle.message((String)"import.defaults.vendor", (Object[])new Object[0]), CvsBundle.message((String)"import.defaults.release_tag", (Object[])new Object[0]), CvsBundle.message((String)"import.defaults.log.message", (Object[])new Object[0]), sourceLocation.getName(), env, new ArrayList<FileExtension>(), new IIgnoreFileFilter(){

            public boolean shouldBeIgnored(AbstractFileObject abstractFileObject, ICvsFileSystem cvsFileSystem) {
                return false;
            }
        });
        return new ImportOperation(details);
    }

    @Override
    public int getFilesToProcessCount() {
        return 2 * this.myDetails.getTotalFilesInSourceDirectory();
    }

    @Override
    protected String getOperationName() {
        return "import";
    }

    @Override
    protected IIgnoreFileFilter getIgnoreFileFilter() {
        return this.myDetails.getIgnoreFileFilter();
    }
}

