/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.VcsError;
import com.intellij.dvcs.push.ui.PushTargetEditorListener;
import com.intellij.dvcs.push.ui.PushTargetTextField;
import com.intellij.dvcs.push.ui.VcsEditableTextComponent;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextFieldWithAutoCompletion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.push.HgTarget;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgPushTargetPanel
extends PushTargetPanel<HgTarget> {
    private static final String ENTER_REMOTE = "Enter Remote";
    private final HgRepository myRepository;
    private final String myBranchName;
    private final TextFieldWithAutoCompletion<String> myDestTargetPanel;
    private final VcsEditableTextComponent myTargetRenderedComponent;

    public HgPushTargetPanel(@NotNull HgRepository repository, @Nullable HgTarget defaultTarget) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/push/HgPushTargetPanel", "<init>"));
        }
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.myRepository = repository;
        this.myBranchName = this.myRepository.getCurrentBranchName();
        List<String> targetVariants = HgUtil.getTargetNames(repository);
        String defaultText = defaultTarget != null ? defaultTarget.getPresentation() : "";
        this.myTargetRenderedComponent = new VcsEditableTextComponent("<a href=''>" + defaultText + "</a>", null);
        this.myDestTargetPanel = new PushTargetTextField(repository.getProject(), targetVariants, defaultText);
        this.add((Component)this.myDestTargetPanel, "Center");
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer, boolean isSelected, boolean isActive, @Nullable String forceRenderedText) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "org/zmlx/hg4idea/push/HgPushTargetPanel", "render"));
        }
        if (forceRenderedText != null) {
            this.myDestTargetPanel.setText(forceRenderedText);
            renderer.append(forceRenderedText);
            return;
        }
        String targetText = this.myDestTargetPanel.getText();
        if (StringUtil.isEmptyOrSpaces((String)targetText)) {
            renderer.append(ENTER_REMOTE, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES, (Object)this);
        }
        this.myTargetRenderedComponent.setSelected(isSelected);
        this.myTargetRenderedComponent.setTransparent(!isActive);
        this.myTargetRenderedComponent.render(renderer);
    }

    @Nullable
    public HgTarget getValue() {
        return this.createValidPushTarget();
    }

    @NotNull
    private HgTarget createValidPushTarget() {
        HgTarget hgTarget = new HgTarget(this.myDestTargetPanel.getText(), this.myBranchName);
        if (hgTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/push/HgPushTargetPanel", "createValidPushTarget"));
        }
        return hgTarget;
    }

    public void fireOnCancel() {
        this.myDestTargetPanel.setText(this.myTargetRenderedComponent.getText());
    }

    public void fireOnChange() {
        this.myTargetRenderedComponent.updateLinkText(this.myDestTargetPanel.getText());
    }

    @Nullable
    public ValidationInfo verify() {
        if (StringUtil.isEmptyOrSpaces((String)this.myDestTargetPanel.getText())) {
            return new ValidationInfo(VcsError.createEmptyTargetError((String)DvcsUtil.getShortRepositoryName((Repository)this.myRepository)).getText(), (JComponent)((Object)this));
        }
        return null;
    }

    public void setFireOnChangeAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/zmlx/hg4idea/push/HgPushTargetPanel", "setFireOnChangeAction"));
        }
    }

    public void addTargetEditorListener(final @NotNull PushTargetEditorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/zmlx/hg4idea/push/HgPushTargetPanel", "addTargetEditorListener"));
        }
        this.myDestTargetPanel.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                super.documentChanged(e);
                listener.onTargetInEditModeChanged(HgPushTargetPanel.this.myDestTargetPanel.getText());
            }
        });
    }
}

