/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.render.pdf.PDFEventProducer;

final class FOToPDFRoleMap {
    private static final Map<String, PDFName> STANDARD_STRUCTURE_TYPES = new HashMap<String, PDFName>();
    private static final Map<String, Mapper> DEFAULT_MAPPINGS = new HashMap<String, Mapper>();
    private static final PDFName THEAD;
    private static final PDFName NON_STRUCT;

    private static void addStructureType(String structureType) {
        STANDARD_STRUCTURE_TYPES.put(structureType, new PDFName(structureType));
    }

    private static void addMapping(String fo, String structureType) {
        PDFName type = STANDARD_STRUCTURE_TYPES.get(structureType);
        assert (type != null);
        FOToPDFRoleMap.addMapping(fo, new SimpleMapper(type));
    }

    private static void addMapping(String fo, Mapper mapper) {
        DEFAULT_MAPPINGS.put(fo, mapper);
    }

    public static PDFName mapFormattingObject(String fo, String role, PDFObject parent, EventBroadcaster eventBroadcaster) {
        PDFName type = null;
        if (role == null) {
            type = FOToPDFRoleMap.getDefaultMappingFor(fo, parent);
        } else {
            type = STANDARD_STRUCTURE_TYPES.get(role);
            if (type == null) {
                type = FOToPDFRoleMap.getDefaultMappingFor(fo, parent);
                PDFEventProducer.Provider.get(eventBroadcaster).nonStandardStructureType(fo, fo, role, type.toString().substring(1));
            }
        }
        assert (type != null);
        return type;
    }

    private static PDFName getDefaultMappingFor(String fo, PDFObject parent) {
        Mapper mapper = DEFAULT_MAPPINGS.get(fo);
        if (mapper != null) {
            return mapper.getStructureType(parent);
        }
        return NON_STRUCT;
    }

    private FOToPDFRoleMap() {
    }

    static {
        FOToPDFRoleMap.addStructureType("Document");
        FOToPDFRoleMap.addStructureType("Part");
        FOToPDFRoleMap.addStructureType("Art");
        FOToPDFRoleMap.addStructureType("Sect");
        FOToPDFRoleMap.addStructureType("Div");
        FOToPDFRoleMap.addStructureType("BlockQuote");
        FOToPDFRoleMap.addStructureType("Caption");
        FOToPDFRoleMap.addStructureType("TOC");
        FOToPDFRoleMap.addStructureType("TOCI");
        FOToPDFRoleMap.addStructureType("Index");
        FOToPDFRoleMap.addStructureType("NonStruct");
        FOToPDFRoleMap.addStructureType("Private");
        FOToPDFRoleMap.addStructureType("H");
        FOToPDFRoleMap.addStructureType("H1");
        FOToPDFRoleMap.addStructureType("H2");
        FOToPDFRoleMap.addStructureType("H3");
        FOToPDFRoleMap.addStructureType("H4");
        FOToPDFRoleMap.addStructureType("H5");
        FOToPDFRoleMap.addStructureType("H6");
        FOToPDFRoleMap.addStructureType("P");
        FOToPDFRoleMap.addStructureType("L");
        FOToPDFRoleMap.addStructureType("LI");
        FOToPDFRoleMap.addStructureType("Lbl");
        FOToPDFRoleMap.addStructureType("LBody");
        FOToPDFRoleMap.addStructureType("Table");
        FOToPDFRoleMap.addStructureType("TR");
        FOToPDFRoleMap.addStructureType("TH");
        FOToPDFRoleMap.addStructureType("TD");
        FOToPDFRoleMap.addStructureType("THead");
        FOToPDFRoleMap.addStructureType("TBody");
        FOToPDFRoleMap.addStructureType("TFoot");
        FOToPDFRoleMap.addStructureType("Span");
        FOToPDFRoleMap.addStructureType("Quote");
        FOToPDFRoleMap.addStructureType("Note");
        FOToPDFRoleMap.addStructureType("Reference");
        FOToPDFRoleMap.addStructureType("BibEntry");
        FOToPDFRoleMap.addStructureType("Code");
        FOToPDFRoleMap.addStructureType("Link");
        FOToPDFRoleMap.addStructureType("Annot");
        FOToPDFRoleMap.addStructureType("Ruby");
        FOToPDFRoleMap.addStructureType("RB");
        FOToPDFRoleMap.addStructureType("RT");
        FOToPDFRoleMap.addStructureType("RP");
        FOToPDFRoleMap.addStructureType("Warichu");
        FOToPDFRoleMap.addStructureType("WT");
        FOToPDFRoleMap.addStructureType("WP");
        FOToPDFRoleMap.addStructureType("Figure");
        FOToPDFRoleMap.addStructureType("Formula");
        FOToPDFRoleMap.addStructureType("Form");
        NON_STRUCT = STANDARD_STRUCTURE_TYPES.get("NonStruct");
        assert (NON_STRUCT != null);
        THEAD = STANDARD_STRUCTURE_TYPES.get("THead");
        assert (THEAD != null);
        FOToPDFRoleMap.addMapping("root", "Document");
        FOToPDFRoleMap.addMapping("page-sequence", "Part");
        FOToPDFRoleMap.addMapping("flow", "Sect");
        FOToPDFRoleMap.addMapping("static-content", "Sect");
        FOToPDFRoleMap.addMapping("block", "P");
        FOToPDFRoleMap.addMapping("block-container", "Div");
        FOToPDFRoleMap.addMapping("character", "Span");
        FOToPDFRoleMap.addMapping("external-graphic", "Figure");
        FOToPDFRoleMap.addMapping("instream-foreign-object", "Figure");
        FOToPDFRoleMap.addMapping("inline", "Span");
        FOToPDFRoleMap.addMapping("inline-container", "Div");
        FOToPDFRoleMap.addMapping("page-number", "Quote");
        FOToPDFRoleMap.addMapping("page-number-citation", "Quote");
        FOToPDFRoleMap.addMapping("page-number-citation-last", "Quote");
        FOToPDFRoleMap.addMapping("table-and-caption", "Div");
        FOToPDFRoleMap.addMapping("table", "Table");
        FOToPDFRoleMap.addMapping("table-caption", "Caption");
        FOToPDFRoleMap.addMapping("table-header", "THead");
        FOToPDFRoleMap.addMapping("table-footer", "TFoot");
        FOToPDFRoleMap.addMapping("table-body", "TBody");
        FOToPDFRoleMap.addMapping("table-row", "TR");
        FOToPDFRoleMap.addMapping("table-cell", new TableCellMapper());
        FOToPDFRoleMap.addMapping("list-block", "L");
        FOToPDFRoleMap.addMapping("list-item", "LI");
        FOToPDFRoleMap.addMapping("list-item-body", "LBody");
        FOToPDFRoleMap.addMapping("list-item-label", "Lbl");
        FOToPDFRoleMap.addMapping("basic-link", "Link");
        FOToPDFRoleMap.addMapping("float", "Div");
        FOToPDFRoleMap.addMapping("footnote", "Note");
        FOToPDFRoleMap.addMapping("footnote-body", "Sect");
        FOToPDFRoleMap.addMapping("wrapper", "Span");
        FOToPDFRoleMap.addMapping("marker", "Private");
    }

    private static class TableCellMapper
    implements Mapper {
        private TableCellMapper() {
        }

        public PDFName getStructureType(PDFObject parent) {
            PDFStructElem grandParent = ((PDFStructElem)parent).getParentStructElem();
            PDFName type = THEAD.equals(grandParent.getStructureType()) ? (PDFName)STANDARD_STRUCTURE_TYPES.get("TH") : (PDFName)STANDARD_STRUCTURE_TYPES.get("TD");
            assert (type != null);
            return type;
        }
    }

    private static class SimpleMapper
    implements Mapper {
        private PDFName structureType;

        public SimpleMapper(PDFName structureType) {
            this.structureType = structureType;
        }

        public PDFName getStructureType(PDFObject parent) {
            return this.structureType;
        }
    }

    private static interface Mapper {
        public PDFName getStructureType(PDFObject var1);
    }
}

