/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import java.io.Serializable;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xml.XMLLib;
import org.mozilla.javascript.xml.XMLObject;
import org.mozilla.javascript.xmlimpl.Namespace;
import org.mozilla.javascript.xmlimpl.QName;
import org.mozilla.javascript.xmlimpl.XML;
import org.mozilla.javascript.xmlimpl.XMLList;
import org.mozilla.javascript.xmlimpl.XMLName;
import org.mozilla.javascript.xmlimpl.XMLObjectImpl;
import org.mozilla.javascript.xmlimpl.XMLWithScope;

public final class XMLLibImpl
extends XMLLib
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Scriptable globalScope;
    XML xmlPrototype;
    XMLList xmlListPrototype;
    Namespace namespacePrototype;
    QName qnamePrototype;
    boolean ignoreComments;
    boolean ignoreProcessingInstructions;
    boolean ignoreWhitespace;
    boolean prettyPrinting;
    int prettyIndent;
    static /* synthetic */ Class class$org$apache$xmlbeans$XmlObject;

    Scriptable globalScope() {
        return this.globalScope;
    }

    private XMLLibImpl(Scriptable scriptable) {
        this.globalScope = scriptable;
        this.defaultSettings();
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        (class$org$apache$xmlbeans$XmlObject == null ? (class$org$apache$xmlbeans$XmlObject = XMLLibImpl.class$("org.apache.xmlbeans.XmlObject")) : class$org$apache$xmlbeans$XmlObject).getName();
        XMLLibImpl xMLLibImpl = new XMLLibImpl(scriptable);
        XMLLib xMLLib = xMLLibImpl.bindToScope(scriptable);
        if (xMLLib == xMLLibImpl) {
            xMLLibImpl.exportToScope(bl);
        }
    }

    private void exportToScope(boolean bl) {
        this.xmlPrototype = XML.createEmptyXML(this);
        this.xmlListPrototype = new XMLList(this);
        this.namespacePrototype = new Namespace(this, "", "");
        this.qnamePrototype = new QName(this, "", "", "");
        this.xmlPrototype.exportAsJSClass(bl);
        this.xmlListPrototype.exportAsJSClass(bl);
        this.namespacePrototype.exportAsJSClass(bl);
        this.qnamePrototype.exportAsJSClass(bl);
    }

    void defaultSettings() {
        this.ignoreComments = true;
        this.ignoreProcessingInstructions = true;
        this.ignoreWhitespace = true;
        this.prettyPrinting = true;
        this.prettyIndent = 2;
    }

    XMLName toAttributeName(Context context, Object object) {
        Serializable serializable;
        String string;
        String string2;
        if (object instanceof String) {
            string2 = "";
            string = (String)object;
        } else {
            if (object instanceof XMLName) {
                XMLName xMLName = (XMLName)object;
                if (!xMLName.isAttributeName()) {
                    xMLName.setAttributeName();
                }
                return xMLName;
            }
            if (object instanceof QName) {
                serializable = (QName)object;
                string2 = ((QName)serializable).uri();
                string = ((QName)serializable).localName();
            } else {
                if (object instanceof Boolean || object instanceof Number || object == Undefined.instance || object == null) {
                    throw XMLLibImpl.badXMLName(object);
                }
                string2 = "";
                string = ScriptRuntime.toString(object);
            }
        }
        serializable = XMLName.formProperty(string2, string);
        ((XMLName)serializable).setAttributeName();
        return serializable;
    }

    private static RuntimeException badXMLName(Object object) {
        String string;
        if (object instanceof Number) {
            string = "Can not construct XML name from number: ";
        } else if (object instanceof Boolean) {
            string = "Can not construct XML name from boolean: ";
        } else if (object == Undefined.instance || object == null) {
            string = "Can not construct XML name from ";
        } else {
            throw new IllegalArgumentException(object.toString());
        }
        return ScriptRuntime.typeError(string + ScriptRuntime.toString(object));
    }

    XMLName toXMLName(Context context, Object object) {
        XMLName xMLName;
        if (object instanceof XMLName) {
            xMLName = (XMLName)object;
        } else if (object instanceof QName) {
            QName qName = (QName)object;
            xMLName = XMLName.formProperty(qName.uri(), qName.localName());
        } else if (object instanceof String) {
            xMLName = this.toXMLNameFromString(context, (String)object);
        } else {
            if (object instanceof Boolean || object instanceof Number || object == Undefined.instance || object == null) {
                throw XMLLibImpl.badXMLName(object);
            }
            String string = ScriptRuntime.toString(object);
            xMLName = this.toXMLNameFromString(context, string);
        }
        return xMLName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    XMLName toXMLNameOrIndex(Context context, Object object) {
        if (object instanceof XMLName) {
            return (XMLName)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            long l = ScriptRuntime.testUint32String(string);
            if (l < 0L) return this.toXMLNameFromString(context, string);
            ScriptRuntime.storeUint32Result(context, l);
            return null;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            long l = (long)d;
            if ((double)l != d) throw XMLLibImpl.badXMLName(object);
            if (0L > l) throw XMLLibImpl.badXMLName(object);
            if (l > 0xFFFFFFFFL) throw XMLLibImpl.badXMLName(object);
            ScriptRuntime.storeUint32Result(context, l);
            return null;
        }
        if (object instanceof QName) {
            long l;
            QName qName = (QName)object;
            String string = qName.uri();
            boolean bl = false;
            XMLName xMLName = null;
            if (string != null && string.length() == 0 && (l = ScriptRuntime.testUint32String(string)) >= 0L) {
                ScriptRuntime.storeUint32Result(context, l);
                bl = true;
            }
            if (bl) return xMLName;
            return XMLName.formProperty(string, qName.localName());
        }
        if (object instanceof Boolean) throw XMLLibImpl.badXMLName(object);
        if (object == Undefined.instance) throw XMLLibImpl.badXMLName(object);
        if (object == null) {
            throw XMLLibImpl.badXMLName(object);
        }
        String string = ScriptRuntime.toString(object);
        long l = ScriptRuntime.testUint32String(string);
        if (l < 0L) return this.toXMLNameFromString(context, string);
        ScriptRuntime.storeUint32Result(context, l);
        return null;
    }

    XMLName toXMLNameFromString(Context context, String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        int n = string.length();
        if (n != 0) {
            char c = string.charAt(0);
            if (c == '*') {
                if (n == 1) {
                    return XMLName.formStar();
                }
            } else if (c == '@') {
                XMLName xMLName = XMLName.formProperty("", string.substring(1));
                xMLName.setAttributeName();
                return xMLName;
            }
        }
        String string2 = this.getDefaultNamespaceURI(context);
        return XMLName.formProperty(string2, string);
    }

    Namespace constructNamespace(Context context, Object object) {
        String string;
        String string2;
        if (object instanceof Namespace) {
            Namespace namespace = (Namespace)object;
            string2 = namespace.prefix();
            string = namespace.uri();
        } else if (object instanceof QName) {
            QName qName = (QName)object;
            string = qName.uri();
            if (string != null) {
                string2 = qName.prefix();
            } else {
                string = qName.toString();
                string2 = null;
            }
        } else {
            string = ScriptRuntime.toString(object);
            string2 = string.length() == 0 ? "" : null;
        }
        return new Namespace(this, string2, string);
    }

    Namespace castToNamespace(Context context, Object object) {
        if (object instanceof Namespace) {
            return (Namespace)object;
        }
        return this.constructNamespace(context, object);
    }

    Namespace constructNamespace(Context context) {
        return new Namespace(this, "", "");
    }

    public Namespace constructNamespace(Context context, Object object, Object object2) {
        String string;
        String string2;
        if (object2 instanceof QName) {
            QName qName = (QName)object2;
            string2 = qName.uri();
            if (string2 == null) {
                string2 = qName.toString();
            }
        } else {
            string2 = ScriptRuntime.toString(object2);
        }
        if (string2.length() == 0) {
            if (object == Undefined.instance) {
                string = "";
            } else {
                string = ScriptRuntime.toString(object);
                if (string.length() != 0) {
                    throw ScriptRuntime.typeError("Illegal prefix '" + string + "' for 'no namespace'.");
                }
            }
        } else {
            string = object == Undefined.instance ? "" : (!this.isXMLName(context, object) ? "" : ScriptRuntime.toString(object));
        }
        return new Namespace(this, string, string2);
    }

    String getDefaultNamespaceURI(Context context) {
        Object object;
        String string = "";
        if (context == null) {
            context = Context.getCurrentContext();
        }
        if (context != null && (object = ScriptRuntime.searchDefaultNamespace(context)) != null && object instanceof Namespace) {
            string = ((Namespace)object).uri();
        }
        return string;
    }

    Namespace getDefaultNamespace(Context context) {
        if (context == null && (context = Context.getCurrentContext()) == null) {
            return this.namespacePrototype;
        }
        Object object = ScriptRuntime.searchDefaultNamespace(context);
        Namespace namespace = object == null ? this.namespacePrototype : (object instanceof Namespace ? (Namespace)object : this.namespacePrototype);
        return namespace;
    }

    QName castToQName(Context context, Object object) {
        if (object instanceof QName) {
            return (QName)object;
        }
        return this.constructQName(context, object);
    }

    QName constructQName(Context context, Object object) {
        QName qName;
        if (object instanceof QName) {
            QName qName2 = (QName)object;
            qName = new QName(this, qName2.uri(), qName2.localName(), qName2.prefix());
        } else {
            String string = ScriptRuntime.toString(object);
            qName = this.constructQNameFromString(context, string);
        }
        return qName;
    }

    QName constructQNameFromString(Context context, String string) {
        String string2;
        String string3;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if ("*".equals(string)) {
            string3 = null;
            string2 = null;
        } else {
            Namespace namespace = this.getDefaultNamespace(context);
            string3 = namespace.uri();
            string2 = namespace.prefix();
        }
        return new QName(this, string3, string, string2);
    }

    QName constructQName(Context context, Object object, Object object2) {
        String string;
        String string2;
        String string3;
        IdScriptableObject idScriptableObject;
        if (object2 instanceof QName) {
            idScriptableObject = (QName)object2;
            string3 = idScriptableObject.localName();
        } else {
            string3 = ScriptRuntime.toString(object2);
        }
        idScriptableObject = object == Undefined.instance ? ("*".equals(string3) ? null : this.getDefaultNamespace(context)) : (object == null ? null : (object instanceof Namespace ? (Namespace)object : this.constructNamespace(context, object)));
        if (idScriptableObject == null) {
            string2 = null;
            string = null;
        } else {
            string2 = ((Namespace)idScriptableObject).uri();
            string = ((Namespace)idScriptableObject).prefix();
        }
        return new QName(this, string2, string3, string);
    }

    Object addXMLObjects(Context context, XMLObject xMLObject, XMLObject xMLObject2) {
        XMLList xMLList;
        XMLList xMLList2 = new XMLList(this);
        if (xMLObject instanceof XMLList) {
            xMLList = (XMLList)xMLObject;
            if (xMLList.length() == 1) {
                xMLList2.addToList(xMLList.item(0));
            } else {
                xMLList2 = new XMLList(this, (Object)xMLObject);
            }
        } else {
            xMLList2.addToList(xMLObject);
        }
        if (xMLObject2 instanceof XMLList) {
            xMLList = (XMLList)xMLObject2;
            for (int i = 0; i < xMLList.length(); ++i) {
                xMLList2.addToList(xMLList.item(i));
            }
        } else if (xMLObject2 instanceof XML) {
            xMLList2.addToList(xMLObject2);
        }
        return xMLList2;
    }

    public boolean isXMLName(Context context, Object object) {
        String string;
        try {
            string = ScriptRuntime.toString(object);
        }
        catch (EcmaError ecmaError) {
            if ("TypeError".equals(ecmaError.getName())) {
                return false;
            }
            throw ecmaError;
        }
        int n = string.length();
        if (n != 0 && XMLLibImpl.isNCNameStartChar(string.charAt(0))) {
            for (int i = 1; i != n; ++i) {
                if (XMLLibImpl.isNCNameChar(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isNCNameStartChar(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            if (n >= 97) {
                return n <= 122;
            }
            if (n >= 65) {
                if (n <= 90) {
                    return true;
                }
                return n == 95;
            }
        } else if ((n & 0xFFFFE000) == 0) {
            return 192 <= n && n <= 214 || 216 <= n && n <= 246 || 248 <= n && n <= 767 || 880 <= n && n <= 893 || 895 <= n;
        }
        return 8204 <= n && n <= 8205 || 8304 <= n && n <= 8591 || 11264 <= n && n <= 12271 || 12289 <= n && n <= 55295 || 63744 <= n && n <= 64975 || 65008 <= n && n <= 65533 || 65536 <= n && n <= 983039;
    }

    private static boolean isNCNameChar(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            if (n >= 97) {
                return n <= 122;
            }
            if (n >= 65) {
                if (n <= 90) {
                    return true;
                }
                return n == 95;
            }
            if (n >= 48) {
                return n <= 57;
            }
            return n == 45 || n == 46;
        }
        if ((n & 0xFFFFE000) == 0) {
            return XMLLibImpl.isNCNameStartChar(n) || n == 183 || 768 <= n && n <= 879;
        }
        return XMLLibImpl.isNCNameStartChar(n) || 8255 <= n && n <= 8256;
    }

    XMLName toQualifiedName(Context context, Object object, Object object2) {
        String string;
        IdScriptableObject idScriptableObject;
        if (object2 instanceof QName) {
            idScriptableObject = (QName)object2;
            string = idScriptableObject.localName();
        } else {
            string = ScriptRuntime.toString(object2);
        }
        idScriptableObject = object == Undefined.instance ? ("*".equals(string) ? null : this.getDefaultNamespace(context)) : (object == null ? null : (object instanceof Namespace ? (Namespace)object : this.constructNamespace(context, object)));
        String string2 = idScriptableObject == null ? null : ((Namespace)idScriptableObject).uri();
        return XMLName.formProperty(string2, string);
    }

    public Ref nameRef(Context context, Object object, Scriptable scriptable, int n) {
        if ((n & 2) == 0) {
            throw Kit.codeBug();
        }
        XMLName xMLName = this.toAttributeName(context, object);
        return this.xmlPrimaryReference(context, xMLName, scriptable);
    }

    public Ref nameRef(Context context, Object object, Object object2, Scriptable scriptable, int n) {
        XMLName xMLName = this.toQualifiedName(context, object, object2);
        if ((n & 2) != 0 && !xMLName.isAttributeName()) {
            xMLName.setAttributeName();
        }
        return this.xmlPrimaryReference(context, xMLName, scriptable);
    }

    private Ref xmlPrimaryReference(Context context, XMLName xMLName, Scriptable scriptable) {
        XMLObjectImpl xMLObjectImpl;
        block2: {
            XMLObjectImpl xMLObjectImpl2 = null;
            do {
                if (!(scriptable instanceof XMLWithScope)) continue;
                xMLObjectImpl = (XMLObjectImpl)scriptable.getPrototype();
                if (xMLObjectImpl.hasXMLProperty(xMLName)) break block2;
                if (xMLObjectImpl2 != null) continue;
                xMLObjectImpl2 = xMLObjectImpl;
            } while ((scriptable = scriptable.getParentScope()) != null);
            xMLObjectImpl = xMLObjectImpl2;
        }
        if (xMLObjectImpl != null) {
            xMLName.initXMLObject(xMLObjectImpl);
        }
        return xMLName;
    }

    public String escapeAttributeValue(Object object) {
        String string = ScriptRuntime.toString(object);
        if (string.length() == 0) {
            return "\"\"";
        }
        XmlObject xmlObject = XmlObject.Factory.newInstance();
        XmlCursor xmlCursor = xmlObject.newCursor();
        xmlCursor.toNextToken();
        xmlCursor.beginElement("a");
        xmlCursor.insertAttributeWithValue("a", string);
        xmlCursor.dispose();
        String string2 = xmlObject.toString();
        int n = string2.indexOf(34);
        int n2 = string2.lastIndexOf(34);
        return string2.substring(n, n2 + 1);
    }

    public String escapeTextValue(Object object) {
        if (object instanceof XMLObjectImpl) {
            return ((XMLObjectImpl)object).toXMLString(0);
        }
        String string = ScriptRuntime.toString(object);
        if (string.length() == 0) {
            return string;
        }
        XmlObject xmlObject = XmlObject.Factory.newInstance();
        XmlCursor xmlCursor = xmlObject.newCursor();
        xmlCursor.toNextToken();
        xmlCursor.beginElement("a");
        xmlCursor.insertChars(string);
        xmlCursor.dispose();
        String string2 = xmlObject.toString();
        int n = string2.indexOf(62) + 1;
        int n2 = string2.lastIndexOf(60);
        return n < n2 ? string2.substring(n, n2) : "";
    }

    public Object toDefaultXmlNamespace(Context context, Object object) {
        return this.constructNamespace(context, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

