/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferio;

import java.io.BufferedOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.CharacterCodingException;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferio.IoTask;
import org.gjt.sp.jedit.io.Encoding;
import org.gjt.sp.jedit.io.EncodingServer;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.SegmentBuffer;

public abstract class BufferIORequest
extends IoTask {
    public static final int IOBUFSIZE = 32768;
    public static final int PROGRESS_INTERVAL = 300;
    public static final String LOAD_DATA = "BufferIORequest__loadData";
    public static final String END_OFFSETS = "BufferIORequest__endOffsets";
    public static final String NEW_PATH = "BufferIORequest__newPath";
    public static final String ERROR_OCCURRED = "BufferIORequest__error";
    protected final View view;
    protected final Buffer buffer;
    protected final Object session;
    protected final VFS vfs;
    protected String path;
    protected final String markersPath;

    protected BufferIORequest(View view, Buffer buffer, Object object, VFS vFS, String string) {
        this.view = view;
        this.buffer = buffer;
        this.session = object;
        this.vfs = vFS;
        this.path = string;
        this.markersPath = Buffer.getMarkersPath(vFS, string);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '[' + this.buffer + ']';
    }

    public static int getCharIOBufferSize() {
        return 32768;
    }

    public static int getByteIOBufferSize() {
        return 65536;
    }

    protected Reader autodetect(InputStream inputStream) throws IOException {
        return MiscUtilities.autodetect(inputStream, this.buffer);
    }

    protected SegmentBuffer read(Reader reader, long l, boolean bl) throws IOException, InterruptedException {
        char c;
        int n;
        int n2;
        boolean bl2;
        IntegerArray integerArray = new IntegerArray(Math.max(1, (int)(l / 50L)));
        boolean bl3 = bl2 = !this.buffer.isTemporary() && l != 0L;
        if (bl2) {
            this.setMaximum(l);
            this.setValue(0L);
        }
        if (l == 0L) {
            l = 32768L;
        }
        SegmentBuffer segmentBuffer = new SegmentBuffer((int)l + 1);
        char[] cArray = new char[32768];
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n3 = 0;
        while ((n2 = reader.read(cArray, 0, cArray.length)) != -1) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            int n4 = 0;
            block5: for (n = 0; n < n2; ++n) {
                switch (cArray[n]) {
                    case '\r': {
                        if (bl6) {
                            bl5 = true;
                            bl4 = false;
                        } else {
                            bl6 = true;
                        }
                        segmentBuffer.append(cArray, n4, n - n4);
                        segmentBuffer.append('\n');
                        integerArray.add(segmentBuffer.count);
                        if (bl2 && n3++ % 300 == 0) {
                            this.setValue(segmentBuffer.count);
                        }
                        n4 = n + 1;
                        continue block5;
                    }
                    case '\n': {
                        if (bl6) {
                            bl5 = false;
                            bl4 = true;
                            bl6 = false;
                            n4 = n + 1;
                            continue block5;
                        }
                        bl5 = false;
                        bl4 = false;
                        segmentBuffer.append(cArray, n4, n - n4);
                        segmentBuffer.append('\n');
                        integerArray.add(segmentBuffer.count);
                        if (bl2 && n3++ % 300 == 0) {
                            this.setValue(segmentBuffer.count);
                        }
                        n4 = n + 1;
                        continue block5;
                    }
                    default: {
                        if (!bl6) continue block5;
                        bl5 = true;
                        bl4 = false;
                        bl6 = false;
                    }
                }
            }
            if (bl2) {
                this.setValue(segmentBuffer.count);
            }
            segmentBuffer.append(cArray, n4, n2 - n4);
        }
        this.setCancellable(false);
        String string = segmentBuffer.count == 0 ? jEdit.getProperty("buffer.lineSeparator", System.getProperty("line.separator")) : (bl4 ? "\r\n" : (bl5 ? "\r" : "\n"));
        n = segmentBuffer.count--;
        if (n == 0 || (c = segmentBuffer.array[n - 1]) == '\u001a') {
            // empty if block
        }
        this.buffer.setBooleanProperty("trailingEOL", false);
        if (n != 0 && jEdit.getBooleanProperty("stripTrailingEOL") && (c = segmentBuffer.array[n - 1]) == '\n') {
            this.buffer.setBooleanProperty("trailingEOL", true);
            --segmentBuffer.count;
            integerArray.setSize(integerArray.getSize() - 1);
        }
        integerArray.add(segmentBuffer.count + 1);
        if (!bl) {
            this.buffer.setProperty(LOAD_DATA, segmentBuffer);
            this.buffer.setProperty(END_OFFSETS, integerArray);
            this.buffer.setProperty(NEW_PATH, this.path);
            if (string != null) {
                this.buffer.setProperty("lineSeparator", string);
            }
        }
        return segmentBuffer;
    }

    protected void write(Buffer buffer, OutputStream outputStream) throws IOException, InterruptedException {
        String string = buffer.getStringProperty("encoding");
        Encoding encoding = EncodingServer.getEncoding(string);
        Writer writer = encoding.getTextWriter(new BufferedOutputStream(outputStream, BufferIORequest.getByteIOBufferSize()));
        Segment segment = new Segment();
        String string2 = buffer.getStringProperty("lineSeparator");
        if (string2 == null) {
            string2 = System.getProperty("line.separator");
        }
        int n = buffer.getLineCount();
        this.setMaximum(n / 300);
        this.setValue(0L);
        int n2 = 0;
        while (n2 < n) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            buffer.getLineText(n2, segment);
            try {
                writer.write(segment.array, segment.offset, segment.count);
                if (n2 < n - 1 || jEdit.getBooleanProperty("stripTrailingEOL") && buffer.getBooleanProperty("trailingEOL")) {
                    writer.write(string2);
                }
            }
            catch (CharacterCodingException characterCodingException) {
                String string3 = BufferIORequest.getWriteEncodingErrorMessage(string, encoding, segment, n2);
                CharConversionException charConversionException = new CharConversionException(string3);
                charConversionException.initCause(characterCodingException);
                throw charConversionException;
            }
            if (++n2 % 300 != 0) continue;
            this.setValue(n2 / 300);
        }
        writer.flush();
    }

    private static String getWriteEncodingErrorMessage(String string, Encoding encoding, Segment segment, int n) {
        Object[] objectArray = new String[]{string, Integer.toString(n + 1), "UNKNOWN", "UNKNOWN"};
        try {
            int n2 = BufferIORequest.getFirstGuiltyCharacterIndex(encoding, segment);
            if (0 <= n2 && n2 < segment.count) {
                char c = segment.array[segment.offset + n2];
                objectArray[2] = Integer.toString(n2 + 1);
                objectArray[3] = "'" + c + "' (U+" + Integer.toHexString(c).toUpperCase() + ")";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jEdit.getProperty("ioerror.write-encoding-error", objectArray);
    }

    private static int getFirstGuiltyCharacterIndex(Encoding encoding, Segment segment) throws IOException {
        if (segment.count < 1) {
            return -1;
        }
        if (segment.count == 1) {
            return 0;
        }
        Writer writer = encoding.getTextWriter(new OutputStream(){

            @Override
            public void write(int n) {
            }
        });
        for (int i = 0; i < segment.count; ++i) {
            try {
                writer.write(segment.array[segment.offset + i]);
                continue;
            }
            catch (CharacterCodingException characterCodingException) {
                return i;
            }
        }
        return -1;
    }
}

