/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.KeyEventTranslator;

public abstract class EnhancedDialog
extends JDialog {
    protected KeyHandler keyHandler;
    protected boolean enterEnabled;

    protected EnhancedDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this._init();
    }

    protected EnhancedDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this._init();
    }

    public boolean getEnterEnabled() {
        return this.enterEnabled;
    }

    public void setEnterEnabled(boolean bl) {
        this.enterEnabled = bl;
    }

    public abstract void ok();

    public abstract void cancel();

    private void _init() {
        this.getLayeredPane().addContainerListener(new ContainerHandler());
        this.getContentPane().addContainerListener(new ContainerHandler());
        this.keyHandler = new KeyHandler();
        this.addKeyListener(this.keyHandler);
        this.addWindowListener(new WindowHandler());
        this.setDefaultCloseOperation(0);
        this.enterEnabled = true;
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            EnhancedDialog.this.cancel();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Component component;
            if (keyEvent.isConsumed()) {
                return;
            }
            if (keyEvent.getKeyCode() == 10 && EnhancedDialog.this.enterEnabled) {
                for (component = EnhancedDialog.this.getFocusOwner(); component != null; component = component.getParent()) {
                    Object object;
                    if (!(component instanceof JComboBox)) continue;
                    JComboBox jComboBox = (JComboBox)component;
                    if (jComboBox.isEditable() && (object = jComboBox.getEditor().getItem()) != null) {
                        jComboBox.setSelectedItem(object);
                    }
                    if (jComboBox.isPopupVisible()) {
                        keyEvent.consume();
                        jComboBox.setPopupVisible(false);
                    }
                    return;
                }
                keyEvent.consume();
                EnhancedDialog.this.ok();
            } else if (keyEvent.getKeyCode() == 27 || this.isCloseBufferShortcut(keyEvent)) {
                keyEvent.consume();
                if (component instanceof JComboBox) {
                    JComboBox jComboBox = (JComboBox)component;
                    if (jComboBox.isPopupVisible()) {
                        jComboBox.setPopupVisible(false);
                    } else {
                        EnhancedDialog.this.cancel();
                    }
                } else {
                    EnhancedDialog.this.cancel();
                }
            }
        }

        private boolean isCloseBufferShortcut(KeyEvent keyEvent) {
            String[] stringArray = GUIUtilities.getShortcutLabel("close-buffer", false).split(" or ");
            if (stringArray.length == 1) {
                if (stringArray[0].contains(" ")) {
                    return false;
                }
                return KeyEventTranslator.parseKey(stringArray[0]).equals(KeyEventTranslator.translateKeyEvent(keyEvent));
            }
            boolean bl = false;
            boolean bl2 = false;
            if (!stringArray[0].contains(" ")) {
                bl2 = KeyEventTranslator.parseKey(stringArray[0]).equals(KeyEventTranslator.translateKeyEvent(keyEvent));
            }
            if (!bl2 && !stringArray[1].contains(" ")) {
                bl = KeyEventTranslator.parseKey(stringArray[1]).equals(KeyEventTranslator.translateKeyEvent(keyEvent));
            }
            return bl2 || bl;
        }
    }

    class ContainerHandler
    extends ContainerAdapter {
        ContainerHandler() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            this.componentAdded(containerEvent.getChild());
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            this.componentRemoved(containerEvent.getChild());
        }

        private void componentAdded(Component component) {
            component.addKeyListener(EnhancedDialog.this.keyHandler);
            if (component instanceof Container) {
                Component[] componentArray;
                Container container = (Container)component;
                container.addContainerListener(this);
                for (Component component2 : componentArray = container.getComponents()) {
                    this.componentAdded(component2);
                }
            }
        }

        private void componentRemoved(Component component) {
            component.removeKeyListener(EnhancedDialog.this.keyHandler);
            if (component instanceof Container) {
                Component[] componentArray;
                Container container = (Container)component;
                container.removeContainerListener(this);
                for (Component component2 : componentArray = container.getComponents()) {
                    this.componentRemoved(component2);
                }
            }
        }
    }
}

