/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;

public class SelectLineRange
extends EnhancedDialog
implements ActionListener {
    private View view;
    private JTextField startField;
    private JTextField endField;
    private JButton ok;
    private JButton cancel;

    public SelectLineRange(View view) {
        super(view, jEdit.getProperty("selectlinerange.title"), true);
        this.view = view;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 0));
        this.setContentPane(jPanel);
        JLabel jLabel = new JLabel(jEdit.getProperty("selectlinerange.caption"));
        jLabel.setBorder(new EmptyBorder(0, 0, 6, 12));
        jPanel.add("North", jLabel);
        JPanel jPanel2 = this.createFieldPanel();
        jPanel.add("Center", jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new EmptyBorder(6, 0, 0, 12));
        jPanel2.add(Box.createGlue());
        jPanel2.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(this);
        this.getRootPane().setDefaultButton(this.ok);
        jPanel2.add(this.ok);
        jPanel2.add(Box.createHorizontalStrut(6));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(this);
        jPanel2.add(this.cancel);
        jPanel2.add(Box.createGlue());
        jPanel.add((Component)jPanel2, "South");
        GUIUtilities.requestFocus(this, this.startField);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        int n;
        int n2;
        try {
            n2 = Integer.parseInt(this.startField.getText()) - 1;
            n = Integer.parseInt(this.endField.getText()) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            this.getToolkit().beep();
            return;
        }
        Buffer buffer = this.view.getBuffer();
        if (n2 < 0 || n >= buffer.getLineCount() || n2 > n) {
            this.getToolkit().beep();
            return;
        }
        JEditTextArea jEditTextArea = this.view.getTextArea();
        Selection.Range range = new Selection.Range(buffer.getLineStartOffset(n2), buffer.getLineEndOffset(n) - 1);
        if (jEditTextArea.isMultipleSelectionEnabled()) {
            jEditTextArea.addToSelection(range);
        } else {
            jEditTextArea.setSelection(range);
        }
        jEditTextArea.moveCaretPosition(buffer.getLineEndOffset(n) - 1);
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            this.ok();
        } else if (object == this.cancel) {
            this.cancel();
        }
    }

    private JPanel createFieldPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 6, 12);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        JLabel jLabel = new JLabel(jEdit.getProperty("selectlinerange.start"), 4);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.startField = new JTextField(10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.startField, gridBagConstraints);
        jPanel.add(this.startField);
        jLabel = new JLabel(jEdit.getProperty("selectlinerange.end"), 4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.endField = new JTextField(10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.endField, gridBagConstraints);
        jPanel.add(this.endField);
        return jPanel;
    }
}

