/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.ManagePanel;

class PluginDetailPanel
extends JPanel {
    private final JEditorPane pluginDetail;
    private final JLabel title;
    private ManagePanel.Entry entry;

    PluginDetailPanel() {
        this.setLayout(new BorderLayout());
        this.pluginDetail = new JEditorPane();
        this.pluginDetail.setEditable(false);
        this.pluginDetail.setContentType("text/html");
        this.pluginDetail.setBackground(jEdit.getColorProperty("view.bgColor"));
        this.pluginDetail.setForeground(jEdit.getColorProperty("view.fgColor"));
        this.pluginDetail.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.title = new JLabel();
        this.add((Component)this.title, "North");
        JScrollPane jScrollPane = new JScrollPane(this.pluginDetail);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.add(jScrollPane);
    }

    void setPlugin(ManagePanel.Entry entry) {
        if (entry != this.entry) {
            if (entry.status.equals("loaded")) {
                if (entry.name == null) {
                    this.title.setText("<html><b>" + entry.jar + "</b></html>");
                } else {
                    this.title.setText("<html><b>" + entry.name + "</b></html>");
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (entry.version != null) {
                    stringBuilder.append("<b>").append(jEdit.getProperty("install-plugins.info.version", "Version")).append("</b>: ").append(entry.version).append("<br>");
                }
                if (entry.author != null) {
                    stringBuilder.append("<b>").append(jEdit.getProperty("install-plugins.info.author", "Author")).append("</b>: ").append(entry.author).append("<br>");
                }
                if (entry.description != null) {
                    stringBuilder.append("<br>").append(entry.description);
                }
                stringBuilder.append(this.getDepends(entry));
                this.pluginDetail.setText(stringBuilder.toString());
            } else {
                this.title.setText("<html><b>" + entry.jar + "</b></html>");
                PluginJAR pluginJAR = new PluginJAR(new File(entry.jar));
                pluginJAR.init();
                entry.plugin = pluginJAR.getPlugin();
                String string = pluginJAR.getPlugin().getClassName();
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("<b>").append(jEdit.getProperty("install-plugin.info.version", "Version")).append("</b>: ").append(jEdit.getProperty("plugin." + string + ".version", ""));
                stringBuilder.append("<br><b>").append(jEdit.getProperty("install-plugin.info.author", "Author")).append("</b>: ").append(jEdit.getProperty("plugin." + string + ".author", ""));
                stringBuilder.append("<br>").append(jEdit.getProperty("plugin." + string + ".description", ""));
                stringBuilder.append(this.getDepends(entry));
                this.pluginDetail.setText(stringBuilder.toString());
                pluginJAR.uninit(false);
            }
            this.entry = entry;
        }
    }

    private String getDepends(ManagePanel.Entry entry) {
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> set = entry.getDependencies();
        if (set != null && !set.isEmpty()) {
            stringBuilder.append("<br><br><b>").append(jEdit.getProperty("install-plugins.info.depends", "Depends on")).append("</b>:");
            ArrayList<String> arrayList = new ArrayList<String>(set);
            Collections.sort(arrayList);
            int n = 0;
            for (String string : arrayList) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(" ").append(string);
                ++n;
            }
        }
        return stringBuilder.toString();
    }
}

