/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class BioExt {
    private Viewer vwr;
    private ModelSet ms;
    private static final String[] qColor = new String[]{"yellow", "orange", "purple"};
    private static final String[] pdbRecords = new String[]{"ATOM  ", "MODEL ", "HETATM"};
    private static final String naNoH = "A3;A1;C3;G3;I3";
    private static final String aaSp2 = "ARGN;ASNN;ASNO;ASPO;GLNN;GLNO;GLUO;HISN;HISC;PHECTRPC;TRPN;TYRC";
    private static final String aaSp21 = "ARGNE;ARGNH1;ASNNH2;GLNNE2;TRPNE1;HISNE2";
    private static final String aaPlus = "LYSN";

    BioExt set(Viewer vwr, ModelSet ms) {
        this.vwr = vwr;
        this.ms = ms;
        return this;
    }

    void getAllPolymerInfo(BS bs, Map<String, Lst<Map<String, Object>>> fullInfo) {
        Lst modelVector = new Lst();
        int modelCount = this.ms.mc;
        Model[] models = this.ms.am;
        for (int i = 0; i < modelCount; ++i) {
            if (!models[i].isBioModel) continue;
            BioModel m = (BioModel)models[i];
            Hashtable<String, Serializable> modelInfo = new Hashtable<String, Serializable>();
            Lst info = new Lst();
            for (int ip = 0; ip < m.bioPolymerCount; ++ip) {
                BioPolymer bp = m.bioPolymers[ip];
                Hashtable<String, Object> pInfo = new Hashtable<String, Object>();
                Lst<Map<String, Object>> mInfo = new Lst<Map<String, Object>>();
                Lst<Hashtable<String, Object>> sInfo = null;
                ProteinStructure psLast = null;
                int n = 0;
                P3 ptTemp = new P3();
                for (int im = 0; im < bp.monomerCount; ++im) {
                    if (!bs.get(bp.monomers[im].leadAtomIndex)) continue;
                    Map<String, Object> monomerInfo = bp.monomers[im].getMyInfo(ptTemp);
                    monomerInfo.put("monomerIndex", im);
                    mInfo.addLast(monomerInfo);
                    ProteinStructure ps = bp.getProteinStructure(im);
                    if (ps == null || ps == psLast) continue;
                    Hashtable<String, Object> psInfo = new Hashtable<String, Object>();
                    psLast = ps;
                    psInfo.put("type", ps.type.getBioStructureTypeName(false));
                    int[] leadAtomIndices = bp.getLeadAtomIndices();
                    int[] iArray = AU.arrayCopyRangeI(leadAtomIndices, ps.monomerIndexFirst, ps.monomerIndexFirst + ps.nRes);
                    psInfo.put("leadAtomIndices", iArray);
                    ps.calcAxis();
                    if (ps.axisA != null) {
                        psInfo.put("axisA", ps.axisA);
                        psInfo.put("axisB", ps.axisB);
                        psInfo.put("axisUnitVector", ps.axisUnitVector);
                    }
                    psInfo.put("index", n++);
                    if (sInfo == null) {
                        sInfo = new Lst<Hashtable<String, Object>>();
                    }
                    sInfo.addLast(psInfo);
                }
                if (mInfo.size() > 0) {
                    pInfo.put("sequence", bp.getSequence());
                    pInfo.put("monomers", mInfo);
                    if (sInfo != null) {
                        pInfo.put("structures", sInfo);
                    }
                }
                if (pInfo.isEmpty()) continue;
                info.addLast(pInfo);
            }
            if (info.size() <= 0) continue;
            modelInfo.put("modelIndex", Integer.valueOf(m.modelIndex));
            modelInfo.put("polymers", info);
            modelVector.addLast(modelInfo);
        }
        fullInfo.put("models", modelVector);
    }

    void calculateStraightnessAll() {
        char qtype = this.vwr.getQuaternionFrame();
        int mStep = this.vwr.getInt(0x21000012);
        int i = this.ms.mc;
        while (--i >= 0) {
            if (!this.ms.am[i].isBioModel) continue;
            BioModel m = (BioModel)this.ms.am[i];
            P3 ptTemp = new P3();
            for (int p = 0; p < m.bioPolymerCount; ++p) {
                this.getPdbData(m.bioPolymers[p], 'S', qtype, mStep, 2, null, null, false, false, false, null, null, null, new BS(), ptTemp);
            }
        }
        this.ms.haveStraightness = true;
    }

    private void getPdbData(BioPolymer bp, char ctype, char qtype, int mStep, int derivType, BS bsAtoms, BS bsSelected, boolean bothEnds, boolean isDraw, boolean addHeader, LabelToken[] tokens, OC pdbATOM, SB pdbCONECT, BS bsWritten, P3 ptTemp) {
        boolean writeRamachandranStraightness;
        boolean quaternionStraightness;
        boolean isRamachandran;
        boolean calcRamachandranStraightness = qtype == 'C' || qtype == 'P';
        boolean bl = isRamachandran = ctype == 'R' || ctype == 'S' && calcRamachandranStraightness;
        if (isRamachandran && !bp.calcPhiPsiAngles()) {
            return;
        }
        boolean isAmino = bp.type == 1;
        boolean isRelativeAlias = ctype == 'r';
        boolean bl2 = quaternionStraightness = !isRamachandran && ctype == 'S';
        if (derivType == 2 && isRelativeAlias) {
            ctype = (char)119;
        }
        if (quaternionStraightness) {
            derivType = 2;
        }
        boolean useQuaternionStraightness = ctype == 'S';
        boolean bl3 = writeRamachandranStraightness = "rcpCP".indexOf(qtype) >= 0;
        if (Logger.debugging && (quaternionStraightness || calcRamachandranStraightness)) {
            Logger.debug("For straightness calculation: useQuaternionStraightness = " + useQuaternionStraightness + " and quaternionFrame = " + qtype);
        }
        if (addHeader && !isDraw) {
            pdbATOM.append("REMARK   6    AT GRP CH RESNO  ");
            switch (ctype) {
                default: {
                    pdbATOM.append("x*10___ y*10___ z*10___      w*10__       ");
                    break;
                }
                case 'x': {
                    pdbATOM.append("y*10___ z*10___ w*10___      x*10__       ");
                    break;
                }
                case 'y': {
                    pdbATOM.append("z*10___ w*10___ x*10___      y*10__       ");
                    break;
                }
                case 'z': {
                    pdbATOM.append("w*10___ x*10___ y*10___      z*10__       ");
                    break;
                }
                case 'R': {
                    if (writeRamachandranStraightness) {
                        pdbATOM.append("phi____ psi____ theta         Straightness");
                        break;
                    }
                    pdbATOM.append("phi____ psi____ omega-180    PartialCharge");
                }
            }
            pdbATOM.append("    Sym   q0_______ q1_______ q2_______ q3_______");
            pdbATOM.append("  theta_  aaX_______ aaY_______ aaZ_______");
            if (ctype != 'R') {
                pdbATOM.append("  centerX___ centerY___ centerZ___");
            }
            if (qtype == 'n') {
                pdbATOM.append("  NHX_______ NHY_______ NHZ_______");
            }
            pdbATOM.append("\n\n");
        }
        float factor = ctype == 'R' ? 1.0f : 10.0f;
        bothEnds = false;
        int j = 0;
        while (j < (bothEnds ? 2 : 1)) {
            for (int i = 0; i < (mStep < 1 ? 1 : mStep); ++i) {
                if (!bp.hasStructure) continue;
                this.getData(i, mStep, bp, ctype, qtype, derivType, bsAtoms, bsSelected, isDraw, isRamachandran, calcRamachandranStraightness, useQuaternionStraightness, writeRamachandranStraightness, quaternionStraightness, factor, isAmino, isRelativeAlias, tokens, pdbATOM, pdbCONECT, bsWritten, ptTemp);
            }
            ++j;
            factor *= -1.0f;
        }
    }

    private void getData(int m0, int mStep, BioPolymer p, char ctype, char qtype, int derivType, BS bsAtoms, BS bsSelected, boolean isDraw, boolean isRamachandran, boolean calcRamachandranStraightness, boolean useQuaternionStraightness, boolean writeRamachandranStraightness, boolean quaternionStraightness, float factor, boolean isAmino, boolean isRelativeAlias, LabelToken[] tokens, OC pdbATOM, SB pdbCONECT, BS bsWritten, P3 ptTemp) {
        String prefix = derivType > 0 ? "dq" + (derivType == 2 ? "2" : "") : "q";
        Atom aprev = null;
        Quat qprev = null;
        Quat dq = null;
        Quat dqprev = null;
        Quat qref = null;
        Atom atomLast = null;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float w = 0.0f;
        String strExtra = "";
        float val1 = Float.NaN;
        float val2 = Float.NaN;
        P3 pt = isDraw ? new P3() : null;
        int dm = mStep <= 1 ? 1 : mStep;
        for (int m = m0; m < p.monomerCount; m += dm) {
            Quat q;
            Monomer monomer = p.monomers[m];
            if (bsAtoms != null && !bsAtoms.get(monomer.leadAtomIndex)) continue;
            Atom a = monomer.getLeadAtom();
            String id = monomer.getUniqueID();
            if (isRamachandran) {
                float straightness;
                if (ctype == 'S') {
                    monomer.setGroupParameter(1111490574, Float.NaN);
                }
                x = monomer.getGroupParameter(1111490569);
                y = monomer.getGroupParameter(1111490570);
                z = monomer.getGroupParameter(1111490568);
                if (z < -90.0f) {
                    z += 360.0f;
                }
                if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z -= 180.0f)) {
                    if (bsAtoms == null) continue;
                    bsAtoms.clear(a.i);
                    continue;
                }
                float angledeg = writeRamachandranStraightness ? p.calculateRamachandranHelixAngle(m, qtype) : 0.0f;
                float f = straightness = calcRamachandranStraightness || writeRamachandranStraightness ? BioExt.getStraightness((float)Math.cos((double)(angledeg / 2.0f / 180.0f) * Math.PI)) : 0.0f;
                if (ctype == 'S') {
                    monomer.setGroupParameter(1111490574, straightness);
                    continue;
                }
                if (isDraw) {
                    if (bsSelected != null && !bsSelected.get(a.getIndex())) continue;
                    AminoMonomer aa = (AminoMonomer)monomer;
                    pt.set(-x, x, 0.5f);
                    pdbATOM.append("draw ID \"phi").append(id).append("\" ARROW ARC ").append(Escape.eP(aa.getNitrogenAtom())).append(Escape.eP(a)).append(Escape.eP(aa.getCarbonylCarbonAtom())).append(Escape.eP(pt)).append(" \"phi = ").append(String.valueOf(Math.round(x))).append("\" color ").append(qColor[2]).append("\n");
                    pt.set(0.0f, y, 0.5f);
                    pdbATOM.append("draw ID \"psi").append(id).append("\" ARROW ARC ").append(Escape.eP(a)).append(Escape.eP(aa.getCarbonylCarbonAtom())).append(Escape.eP(aa.getNitrogenAtom())).append(Escape.eP(pt)).append(" \"psi = ").append(String.valueOf(Math.round(y))).append("\" color ").append(qColor[1]).append("\n");
                    pdbATOM.append("draw ID \"planeNCC").append(id).append("\" ").append(Escape.eP(aa.getNitrogenAtom())).append(Escape.eP(a)).append(Escape.eP(aa.getCarbonylCarbonAtom())).append(" color ").append(qColor[0]).append("\n");
                    pdbATOM.append("draw ID \"planeCNC").append(id).append("\" ").append(Escape.eP(((AminoMonomer)p.monomers[m - 1]).getCarbonylCarbonAtom())).append(Escape.eP(aa.getNitrogenAtom())).append(Escape.eP(a)).append(" color ").append(qColor[1]).append("\n");
                    pdbATOM.append("draw ID \"planeCCN").append(id).append("\" ").append(Escape.eP(a)).append(Escape.eP(aa.getCarbonylCarbonAtom())).append(Escape.eP(((AminoMonomer)p.monomers[m + 1]).getNitrogenAtom())).append(" color ").append(qColor[2]).append("\n");
                    continue;
                }
                if (Float.isNaN(angledeg)) {
                    strExtra = "";
                    if (writeRamachandranStraightness) {
                        continue;
                    }
                } else {
                    q = Quat.newVA(P3.new3(1.0f, 0.0f, 0.0f), angledeg);
                    strExtra = BioExt.getQInfo(q);
                    if (writeRamachandranStraightness) {
                        z = angledeg;
                        w = straightness;
                    } else {
                        w = a.getPartialCharge();
                    }
                }
            } else {
                q = monomer.getQuaternion(qtype);
                if (q != null) {
                    q.setRef(qref);
                    qref = Quat.newQ(q);
                }
                if (derivType == 2) {
                    monomer.setGroupParameter(1111490574, Float.NaN);
                }
                if (q == null) {
                    qprev = null;
                    qref = null;
                } else if (derivType > 0) {
                    Atom anext = a;
                    Quat qnext = q;
                    if (qprev == null) {
                        q = null;
                        dqprev = null;
                    } else {
                        dq = isRelativeAlias ? qprev.leftDifference(q) : q.rightDifference(qprev);
                        if (derivType == 1) {
                            q = dq;
                        } else if (dqprev == null) {
                            q = null;
                        } else {
                            q = dq.rightDifference(dqprev);
                            val1 = BioExt.getQuaternionStraightness(id, dqprev, dq);
                            val2 = BioExt.get3DStraightness(id, dqprev, dq);
                            ((Monomer)aprev.group).setGroupParameter(1111490574, useQuaternionStraightness ? val1 : val2);
                        }
                        dqprev = dq;
                    }
                    aprev = anext;
                    qprev = qnext;
                }
                if (q == null) {
                    atomLast = null;
                    continue;
                }
                switch (ctype) {
                    default: {
                        x = q.q1;
                        y = q.q2;
                        z = q.q3;
                        w = q.q0;
                        break;
                    }
                    case 'x': {
                        x = q.q0;
                        y = q.q1;
                        z = q.q2;
                        w = q.q3;
                        break;
                    }
                    case 'y': {
                        x = q.q3;
                        y = q.q0;
                        z = q.q1;
                        w = q.q2;
                        break;
                    }
                    case 'z': {
                        x = q.q2;
                        y = q.q3;
                        z = q.q0;
                        w = q.q1;
                    }
                }
                P3 ptCenter = monomer.getQuaternionFrameCenter(qtype);
                if (ptCenter == null) {
                    ptCenter = new P3();
                }
                if (isDraw) {
                    if (bsSelected != null && !bsSelected.get(a.getIndex())) continue;
                    int deg = (int)Math.floor(Math.acos(w) * 360.0 / Math.PI);
                    if (derivType == 0) {
                        P3 ptH;
                        pdbATOM.append(Escape.drawQuat(q, prefix, id, ptCenter, 1.0f));
                        if (qtype == 'n' && isAmino && (ptH = ((AminoMonomer)monomer).getNitrogenHydrogenPoint()) != null) {
                            pdbATOM.append("draw ID \"").append(prefix).append("nh").append(id).append("\" width 0.1 ").append(Escape.eP(ptH)).append("\n");
                        }
                    }
                    if (derivType == 1) {
                        pdbATOM.append((String)monomer.getHelixData(135176, qtype, mStep)).append("\n");
                        continue;
                    }
                    pt.set(x * 2.0f, y * 2.0f, z * 2.0f);
                    pdbATOM.append("draw ID \"").append(prefix).append("a").append(id).append("\" VECTOR ").append(Escape.eP(ptCenter)).append(Escape.eP(pt)).append(" \">").append(String.valueOf(deg)).append("\" color ").append(qColor[derivType]).append("\n");
                    continue;
                }
                strExtra = BioExt.getQInfo(q) + PT.sprintf("  %10.5p %10.5p %10.5p", "p", new Object[]{ptCenter});
                if (qtype == 'n' && isAmino) {
                    strExtra = strExtra + PT.sprintf("  %10.5p %10.5p %10.5p", "p", new Object[]{((AminoMonomer)monomer).getNitrogenHydrogenPoint()});
                } else if (derivType == 2 && !Float.isNaN(val1)) {
                    strExtra = strExtra + PT.sprintf(" %10.5f %10.5f", "F", new Object[]{new float[]{val1, val2}});
                }
            }
            if (pdbATOM == null) continue;
            bsWritten.set(((Monomer)a.group).leadAtomIndex);
            this.ms.getLabeler();
            pdbATOM.append(LabelToken.formatLabelAtomArray(this.vwr, a, tokens, '\u0000', null, ptTemp));
            pdbATOM.append(PT.sprintf("%8.2f%8.2f%8.2f      %6.3f          %2s    %s\n", "ssF", new Object[]{a.getElementSymbolIso(false).toUpperCase(), strExtra, new float[]{x * factor, y * factor, z * factor, w * factor}}));
            if (atomLast != null && atomLast.group.getBioPolymerIndexInModel() == a.group.getBioPolymerIndexInModel()) {
                pdbCONECT.append("CONECT").append(PT.formatStringI("%5i", "i", atomLast.getAtomNumber())).append(PT.formatStringI("%5i", "i", a.getAtomNumber())).appendC('\n');
            }
            atomLast = a;
        }
    }

    private static String getQInfo(Quat q) {
        A4 axis = q.toAxisAngle4f();
        return PT.sprintf("%10.6f%10.6f%10.6f%10.6f  %6.2f  %10.5f %10.5f %10.5f", "F", new Object[]{new float[]{q.q0, q.q1, q.q2, q.q3, (float)((double)(axis.angle * 180.0f) / Math.PI), axis.x, axis.y, axis.z}});
    }

    static String drawQuat(Quat q, String prefix, String id, P3 ptCenter, float scale) {
        String strV = " VECTOR " + Escape.eP(ptCenter) + " ";
        if (scale == 0.0f) {
            scale = 1.0f;
        }
        return "draw " + prefix + "x" + id + strV + Escape.eP(q.getVectorScaled(0, scale)) + " color red\n" + "draw " + prefix + "y" + id + strV + Escape.eP(q.getVectorScaled(1, scale)) + " color green\n" + "draw " + prefix + "z" + id + strV + Escape.eP(q.getVectorScaled(2, scale)) + " color blue\n";
    }

    private static float get3DStraightness(String id, Quat dq, Quat dqnext) {
        return dq.getNormal().dot(dqnext.getNormal());
    }

    private static float getQuaternionStraightness(String id, Quat dq, Quat dqnext) {
        return BioExt.getStraightness(dq.dot(dqnext));
    }

    private static float getStraightness(float cosHalfTheta) {
        return (float)(1.0 - 2.0 * Math.acos(Math.abs(cosHalfTheta)) / Math.PI);
    }

    void getPdbDataM(BioModel m, Viewer vwr, String type, char ctype, boolean isDraw, BS bsSelected, OC out, LabelToken[] tokens, SB pdbCONECT, BS bsWritten) {
        int derivType;
        char qtype;
        boolean bothEnds = false;
        char c = ctype != 'R' ? (char)'r' : (qtype = type.length() > 13 && type.indexOf("ramachandran ") >= 0 ? (char)type.charAt(13) : (char)'R');
        if (qtype == 'r') {
            qtype = vwr.getQuaternionFrame();
        }
        int mStep = vwr.getInt(0x21000012);
        int n = type.indexOf("diff") < 0 ? 0 : (derivType = type.indexOf("2") < 0 ? 1 : 2);
        if (!isDraw) {
            out.append("REMARK   6 Jmol PDB-encoded data: " + type + ";");
            if (ctype != 'R') {
                out.append("  quaternionFrame = \"" + qtype + "\"");
                bothEnds = true;
            }
            out.append("\nREMARK   6 Jmol Version ").append(Viewer.getJmolVersion()).append("\n");
            if (ctype == 'R') {
                out.append("REMARK   6 Jmol data min = {-180 -180 -180} max = {180 180 180} unScaledXyz = xyz * {1 1 1} + {0 0 0} plotScale = {100 100 100}\n");
            } else {
                out.append("REMARK   6 Jmol data min = {-1 -1 -1} max = {1 1 1} unScaledXyz = xyz * {0.1 0.1 0.1} + {0 0 0} plotScale = {100 100 100}\n");
            }
        }
        P3 ptTemp = new P3();
        for (int p = 0; p < m.bioPolymerCount; ++p) {
            this.getPdbData(m.bioPolymers[p], ctype, qtype, mStep, derivType, m.bsAtoms, bsSelected, bothEnds, isDraw, p == 0, tokens, out, pdbCONECT, bsWritten, ptTemp);
        }
    }

    int calculateAllstruts(Viewer vwr, ModelSet ms, BS bs1, BS bs2) {
        BS bsCheck;
        vwr.setModelVisibility();
        ms.makeConnections2(0.0f, Float.MAX_VALUE, 32768, 12291, bs1, bs2, null, false, false, 0.0f);
        int iAtom = bs1.nextSetBit(0);
        if (iAtom < 0) {
            return 0;
        }
        Model m = ms.am[ms.at[iAtom].mi];
        if (!m.isBioModel) {
            return 0;
        }
        Lst<Atom> vCA = new Lst<Atom>();
        if (bs1.equals(bs2)) {
            bsCheck = bs1;
        } else {
            bsCheck = BSUtil.copy(bs1);
            bsCheck.or(bs2);
        }
        Atom[] atoms = ms.at;
        bsCheck.and(vwr.getModelUndeletedAtomsBitSet(m.modelIndex));
        int i = bsCheck.nextSetBit(0);
        while (i >= 0) {
            Atom a = atoms[i];
            if (a.checkVisible() && a.atomID == 2 && a.group.groupID != 5 && atoms[i].group.leadAtomIndex >= 0) {
                vCA.addLast(atoms[i]);
            }
            i = bsCheck.nextSetBit(i + 1);
        }
        if (vCA.size() == 0) {
            return 0;
        }
        Lst<Atom[]> struts = BioExt.calculateStruts(ms, bs1, bs2, vCA, vwr.getFloat(0x22000040), vwr.getInt(553648184), vwr.getBoolean(603979955));
        short mad = (short)(vwr.getFloat(570425406) * 2000.0f);
        for (int i2 = 0; i2 < struts.size(); ++i2) {
            Atom[] o = (Atom[])struts.get(i2);
            ms.bondAtoms(o[0], o[1], 32768, mad, null, 0.0f, false, true);
        }
        return struts.size();
    }

    private static Lst<Atom[]> calculateStruts(ModelSet modelSet, BS bs1, BS bs2, Lst<Atom> vCA, float thresh, int delta, boolean allowMultiple) {
        Lst<Atom[]> vStruts = new Lst<Atom[]>();
        float thresh2 = thresh * thresh;
        int n = vCA.size();
        int nEndMin = 3;
        BS bsStruts = new BS();
        BS bsNotAvailable = new BS();
        BS bsNearbyResidues = new BS();
        Atom a1 = (Atom)vCA.get(0);
        int nBiopolymers = modelSet.getBioPolymerCountInModel(a1.mi);
        int[][] biopolymerStartsEnds = new int[nBiopolymers][nEndMin * 2];
        for (int i = 0; i < n; ++i) {
            a1 = (Atom)vCA.get(i);
            int polymerIndex = a1.group.getBioPolymerIndexInModel();
            int monomerIndex = a1.group.getMonomerIndex();
            int bpt = monomerIndex;
            if (bpt < nEndMin) {
                biopolymerStartsEnds[polymerIndex][bpt] = i + 1;
            }
            if ((bpt = ((Monomer)a1.group).getBioPolymerLength() - monomerIndex - 1) >= nEndMin) continue;
            biopolymerStartsEnds[polymerIndex][nEndMin + bpt] = i + 1;
        }
        float[] d2 = new float[n * (n - 1) / 2];
        for (int i = 0; i < n; ++i) {
            a1 = (Atom)vCA.get(i);
            for (int j = i + 1; j < n; ++j) {
                float d;
                int ipt = BioExt.strutPoint(i, j, n);
                Atom a2 = (Atom)vCA.get(j);
                int resno1 = a1.getResno();
                int polymerIndex1 = a1.group.getBioPolymerIndexInModel();
                int resno2 = a2.getResno();
                int polymerIndex2 = a2.group.getBioPolymerIndexInModel();
                if (polymerIndex1 == polymerIndex2 && Math.abs(resno2 - resno1) < delta) {
                    bsNearbyResidues.set(ipt);
                }
                if (!((d = (d2[ipt] = a1.distanceSquared(a2))) >= thresh2)) continue;
                bsNotAvailable.set(ipt);
            }
        }
        int t = 5;
        while (--t >= 0) {
            thresh2 = (thresh - (float)t) * (thresh - (float)t);
            for (int i = 0; i < n; ++i) {
                if (!allowMultiple && bsStruts.get(i)) continue;
                for (int j = i + 1; j < n; ++j) {
                    int ipt = BioExt.strutPoint(i, j, n);
                    if (bsNotAvailable.get(ipt) || bsNearbyResidues.get(ipt) || !allowMultiple && bsStruts.get(j) || !(d2[ipt] <= thresh2)) continue;
                    BioExt.setStrut(i, j, n, vCA, bs1, bs2, vStruts, bsStruts, bsNotAvailable, bsNearbyResidues, delta);
                }
            }
        }
        for (int b = 0; b < nBiopolymers; ++b) {
            for (int k = 0; k < nEndMin * 2; ++k) {
                int i = biopolymerStartsEnds[b][k] - 1;
                if (i < 0 || !bsStruts.get(i)) continue;
                for (int j = 0; j < nEndMin; ++j) {
                    int pt = k / nEndMin * nEndMin + j;
                    i = biopolymerStartsEnds[b][pt] - 1;
                    if (i >= 0) {
                        bsStruts.set(i);
                    }
                    biopolymerStartsEnds[b][pt] = -1;
                }
            }
            if (biopolymerStartsEnds[b][0] == -1 && biopolymerStartsEnds[b][nEndMin] == -1) continue;
            boolean okN = false;
            boolean okC = false;
            int iN = 0;
            int jN = 0;
            int iC = 0;
            int jC = 0;
            float minN = Float.MAX_VALUE;
            float minC = Float.MAX_VALUE;
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < nEndMin * 2; ++k) {
                    int ipt;
                    int i = biopolymerStartsEnds[b][k] - 1;
                    if (i == -2) {
                        k = (k / nEndMin + 1) * nEndMin - 1;
                        continue;
                    }
                    if (j == i || i == -1 || bsNearbyResidues.get(ipt = BioExt.strutPoint(i, j, n)) || d2[ipt] > (k < nEndMin ? minN : minC)) continue;
                    if (k < nEndMin) {
                        if (bsNotAvailable.get(ipt)) {
                            okN = true;
                        }
                        jN = j;
                        iN = i;
                        minN = d2[ipt];
                        continue;
                    }
                    if (bsNotAvailable.get(ipt)) {
                        okC = true;
                    }
                    jC = j;
                    iC = i;
                    minC = d2[ipt];
                }
            }
            if (okN) {
                BioExt.setStrut(iN, jN, n, vCA, bs1, bs2, vStruts, bsStruts, bsNotAvailable, bsNearbyResidues, delta);
            }
            if (!okC) continue;
            BioExt.setStrut(iC, jC, n, vCA, bs1, bs2, vStruts, bsStruts, bsNotAvailable, bsNearbyResidues, delta);
        }
        return vStruts;
    }

    private static int strutPoint(int i, int j, int n) {
        return j < i ? j * (2 * n - j - 1) / 2 + i - j - 1 : i * (2 * n - i - 1) / 2 + j - i - 1;
    }

    private static void setStrut(int i, int j, int n, Lst<Atom> vCA, BS bs1, BS bs2, Lst<Atom[]> vStruts, BS bsStruts, BS bsNotAvailable, BS bsNearbyResidues, int delta) {
        Atom a1 = (Atom)vCA.get(i);
        Atom a2 = (Atom)vCA.get(j);
        if (!bs1.get(a1.i) || !bs2.get(a2.i)) {
            return;
        }
        vStruts.addLast(new Atom[]{a1, a2});
        bsStruts.set(i);
        bsStruts.set(j);
        for (int k1 = Math.max(0, i - delta); k1 <= i + delta && k1 < n; ++k1) {
            for (int k2 = Math.max(0, j - delta); k2 <= j + delta && k2 < n; ++k2) {
                int ipt;
                if (k1 == k2 || bsNearbyResidues.get(ipt = BioExt.strutPoint(k1, k2, n))) continue;
                bsNotAvailable.set(ipt);
            }
        }
    }

    boolean mutate(Viewer vwr, BS bs, String group, String[] sequence) {
        boolean isFile;
        int i0 = bs.nextSetBit(0);
        if (sequence == null) {
            return BioExt.mutateAtom(vwr, i0, group);
        }
        boolean bl = isFile = group == null;
        if (isFile) {
            group = sequence[0];
        }
        Group lastGroup = null;
        boolean isOK = true;
        int i = i0;
        int pt = 0;
        while (i >= 0) {
            block6: {
                block7: {
                    Group g = vwr.ms.at[i].group;
                    if (g == lastGroup) break block6;
                    lastGroup = g;
                    if (isFile) break block7;
                    if ((group = sequence[pt++ % sequence.length]).equals("UNK")) break block6;
                    group = "==" + group;
                }
                BioExt.mutateAtom(vwr, i, group);
            }
            i = bs.nextSetBit(i + 1);
        }
        return isOK;
    }

    private static boolean mutateAtom(Viewer vwr, int iatom, String fileName) {
        ModelSet ms = vwr.ms;
        short iModel = ms.at[iatom].mi;
        if (ms.isTrajectory(iModel)) {
            return false;
        }
        String[] info = vwr.fm.getFileInfo();
        Group g = ms.at[iatom].group;
        if (!(g instanceof AminoMonomer)) {
            return false;
        }
        ((BioModel)ms.am[iModel]).isMutated = true;
        AminoMonomer res0 = (AminoMonomer)g;
        int ac = ms.ac;
        BS bsRes0 = new BS();
        res0.setAtomBits(bsRes0);
        Atom[] backbone = BioExt.getMutationBackbone(res0, null);
        fileName = PT.esc(fileName);
        String script = "try{\n  var atoms0 = {*}\n  var res0 = " + BS.escape(bsRes0, '(', ')') + "\n" + "  load mutate " + fileName + "\n" + "  var res1 = {!atoms0};var r1 = res1[1];var r0 = res1[0]\n" + "  if ({r1 & within(group, r0)}){\n" + "    var haveHs = ({_H & connected(res0)} != 0)\n" + "    if (!haveHs) {delete _H & res1}\n" + "    var sm = '[*.N][*.CA][*.C][*.O]'\n" + "    var keyatoms = res1.find(sm)\n" + "    var x = compare(res1,res0,sm,'BONDS')\n" + "    if(x){\n" + "      print 'mutating ' + res0[1].label('%n%r') + ' to ' + " + fileName + ".trim('=')\n" + "      rotate branch @x\n" + "      compare res1 res0 SMARTS @sm rotate translate 0\n" + "      var c = {!res0 & connected(res0)}\n" + "      var N2 = {*.N & c}\n" + "      var C0 = {*.C & c}\n" + "      var angleH = ({*.H and res0} ? angle({*.C and res0},{*.CA and res0},{*.N and res0},{*.H and res0}) : 1000)\n" + "      delete res0\n" + "      if (N2) {\n" + "        delete (*.OXT,*.HXT) and res1\n" + "        connect {N2} {keyatoms & *.C}\n" + "      }\n" + "      if (C0) {\n" + "        var h1 = {*.H and res1}\n" + "        var n = (h1 ? 0 + {res1 and _H & connected(*.N)} : 0)\n" + "        switch (n) {\n" + "        case 0:\n" + "          break\n" + "        case 1:\n" + "          delete h1\n" + "          break\n" + "        default:\n" + "          var x = angle({*.C and res1},{*.CA and res1},{*.N and res1},h1)\n" + "          rotate branch {*.CA and res1} {*.N and res1} @{angleH-x}\n" + "          delete *.H2 and res1\n" + "          delete *.H3 and res1\n" + "          break\n" + "        }\n" + "        connect {C0} {keyatoms & *.N}\n" + "      }\n" + "    }\n" + "  }\n" + "}catch(e){print e}\n";
        try {
            if (Logger.debugging) {
                Logger.debug(script);
            }
            vwr.eval.runScript(script);
        }
        catch (Exception e) {
            if (!vwr.isJS) {
                e.printStackTrace();
            }
            System.out.println(e);
        }
        ms = vwr.ms;
        if (ms.ac == ac) {
            return false;
        }
        SB sb = ms.am[iModel].loadScript;
        String s = PT.rep(sb.toString(), "load mutate ", "mutate ({" + iatom + "})");
        sb.setLength(0);
        sb.append(s);
        g = ms.at[ms.ac - 1].group;
        if (g != ms.at[ac + 1].group || !(g instanceof AminoMonomer)) {
            BS bsAtoms = new BS();
            g.setAtomBits(bsAtoms);
            vwr.deleteAtoms(bsAtoms, false);
            return false;
        }
        AminoMonomer res1 = (AminoMonomer)g;
        BioExt.getMutationBackbone(res1, backbone);
        BioExt.replaceMutatedMonomer(vwr, res0, res1);
        vwr.fm.setFileInfo(info);
        return true;
    }

    private static void replaceMutatedMonomer(Viewer vwr, AminoMonomer res0, AminoMonomer res1) {
        res1.setResno(res0.getResno());
        res1.chain.groupCount = 0;
        res1.chain = res0.chain;
        res1.chain.model.groupCount = -1;
        res1.proteinStructure = res0.proteinStructure;
        vwr.shm.replaceGroup(res0, res1);
        Group[] groups = res0.chain.groups;
        int i = groups.length;
        while (--i >= 0) {
            if (groups[i] != res0) continue;
            groups[i] = res1;
            break;
        }
        res1.bioPolymer = res0.bioPolymer;
        if (res1.bioPolymer != null) {
            Monomer[] m = res1.bioPolymer.monomers;
            int j = m.length;
            while (--j >= 0) {
                if (m[j] != res0) continue;
                m[j] = res1;
                break;
            }
        }
    }

    private static Atom[] getMutationBackbone(AminoMonomer res1, Atom[] backbone) {
        Atom[] b = new Atom[]{res1.getCarbonylCarbonAtom(), res1.getCarbonylOxygenAtom(), res1.getLeadAtom(), res1.getNitrogenAtom(), res1.getExplicitNH()};
        if (backbone == null) {
            if (b[3].getCovalentHydrogenCount() > 1) {
                b[4] = null;
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                Atom a0 = backbone[i];
                Atom a1 = b[i];
                if (a0 == null || a1 == null) continue;
                a1.setT(a0);
            }
        }
        return b;
    }

    String getFullPDBHeader(Map<String, Object> auxiliaryInfo) {
        String info = this.vwr.getCurrentFileAsString("biomodel");
        int ichMin = info.length();
        int i = pdbRecords.length;
        block4: while (--i >= 0) {
            String strRecord = pdbRecords[i];
            int ichFound = info.startsWith(strRecord) ? 0 : info.indexOf("\n" + strRecord);
            switch (ichFound) {
                case -1: {
                    continue block4;
                }
                case 0: {
                    auxiliaryInfo.put("fileHeader", "");
                    return "";
                }
            }
            if (ichFound >= ichMin) continue;
            ichMin = ++ichFound;
        }
        info = info.substring(0, ichMin);
        auxiliaryInfo.put("fileHeader", info);
        return info;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean getAminoAcidValenceAndCharge(String res, String name, int[] ret) {
        int valence = ret[4];
        ret[4] = 0;
        if (res == null) return false;
        if (res.length() == 0) return false;
        if (res.length() > 3) return false;
        if (name.equals("CA")) return false;
        if (name.equals("CB")) {
            return false;
        }
        char ch0 = name.charAt(0);
        char ch1 = name.length() == 1 ? (char)'\u0000' : name.charAt(1);
        boolean isSp2 = false;
        int bondCount = ret[3];
        block0 : switch (res.length()) {
            case 3: {
                if (name.length() == 1) {
                    switch (ch0) {
                        case 'N': {
                            if (bondCount > 1) {
                                return false;
                            }
                            ret[1] = 1;
                            break block0;
                        }
                        case 'O': {
                            if (valence == 1) {
                                return true;
                            }
                            isSp2 = "HOH;DOD;WAT".indexOf(res) < 0;
                            break block0;
                        }
                    }
                    isSp2 = true;
                    break;
                }
                String id = res + ch0;
                boolean bl = isSp2 = aaSp2.indexOf(id) >= 0;
                if (aaPlus.indexOf(id) >= 0) {
                    ret[1] = 1;
                    break;
                }
                if (ch0 != 'O' || ch1 != 'X') break;
                ret[1] = -1;
                break;
            }
            case 1: 
            case 2: {
                if (name.length() > 2 && name.charAt(2) == '\'') {
                    return false;
                }
                switch (ch0) {
                    case 'C': {
                        if (ch1 != '7') break;
                        return false;
                    }
                    case 'N': {
                        switch (ch1) {
                            case '1': 
                            case '3': {
                                if (naNoH.indexOf("" + res.charAt(res.length() - 1) + ch1) < 0) break;
                                ret[0] = ret[0] - 1;
                                break;
                            }
                            case '7': {
                                ret[0] = ret[0] - 1;
                            }
                        }
                        break;
                    }
                }
                isSp2 = true;
                break;
            }
        }
        if (!isSp2) return true;
        ret[4] = aaSp21.indexOf(res + name) >= 0 ? 0 : 1;
        switch (ch0) {
            case 'N': {
                ret[2] = 2;
                if (valence != 2) return true;
                if (bondCount != 1) return true;
                ret[4] = ret[4] + 1;
                return true;
            }
            case 'C': {
                ret[2] = 2;
                ret[0] = ret[0] - 1;
                return true;
            }
            case 'O': {
                if (valence == 2 && bondCount == 1) {
                    ret[4] = ret[4] - 1;
                }
                ret[0] = ret[0] - 1;
                return true;
            }
        }
        return true;
    }
}

