/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.P3;
import javajs.util.V3;
import org.jmol.modelset.Atom;
import org.jmol.script.T;

public class ContactPair {
    public float[] radii = new float[2];
    public float[] vdws = new float[2];
    public Atom[] myAtoms = new Atom[2];
    public P3 pt;
    public double volume = 0.0;
    public double vdwVolume = 0.0;
    public float score;
    public float d;
    public float chord;
    public int contactType;
    public float xVdwClash = Float.NaN;
    private int oldType = 0;

    public ContactPair(Atom[] atoms, int i1, int i2, float R, float r, float vdwA, float vdwB) {
        this.radii[0] = R;
        this.radii[1] = r;
        this.vdws[0] = vdwA;
        this.vdws[1] = vdwB;
        this.myAtoms[0] = atoms[i1];
        this.myAtoms[1] = atoms[i2];
        V3 v = V3.newVsub(this.myAtoms[1], this.myAtoms[0]);
        this.d = v.length();
        float f = (R - r + this.d) / (2.0f * this.d);
        this.pt = new P3();
        this.pt.scaleAdd2(f, v, this.myAtoms[0]);
        this.score = this.d - vdwA - vdwB;
        int n = this.contactType = this.score < 0.0f ? 1073741881 : 1648363544;
        if (this.score < 0.0f) {
            this.radii[0] = R = vdwA;
            this.radii[1] = r = vdwB;
        }
        this.getVolume();
    }

    private void getVolume() {
        double R = this.radii[0];
        double r = this.radii[1];
        this.volume = R + r - (double)this.d;
        this.volume *= Math.PI * this.volume * ((double)(this.d * this.d) + (double)(2.0f * this.d) * r - 3.0 * r * r + (double)(2.0f * this.d) * R + 6.0 * r * R - 3.0 * R * R) / 12.0 / (double)this.d;
        this.vdwVolume = this.score > 0.0f ? -this.volume : this.volume;
        double a = (double)(this.d * this.d) - r * r + R * R;
        this.chord = (float)Math.sqrt((double)(4.0f * this.d * this.d) * R * R - a * a) / this.d;
    }

    public boolean setForVdwClash(boolean isVdw) {
        if (Float.isNaN(this.xVdwClash)) {
            return false;
        }
        if (isVdw) {
            this.oldType = this.contactType;
            this.contactType = 1648363544;
            this.radii[0] = this.vdws[0] + this.xVdwClash;
            this.radii[1] = this.vdws[1] + this.xVdwClash;
        } else {
            this.contactType = this.oldType;
            this.radii[0] = this.vdws[0];
            this.radii[1] = this.vdws[1];
        }
        this.getVolume();
        return true;
    }

    public void switchAtoms() {
        Atom atom = this.myAtoms[0];
        this.myAtoms[0] = this.myAtoms[1];
        this.myAtoms[1] = atom;
        float r = this.radii[0];
        this.radii[0] = this.radii[1];
        this.radii[1] = r;
        r = this.vdws[0];
        this.vdws[0] = this.vdws[1];
        this.vdws[1] = r;
    }

    public String toString() {
        return "type=" + T.nameOf(this.contactType) + " " + this.myAtoms[0] + " " + this.myAtoms[1] + " dAB=" + this.d + " score=" + this.score + " chord=" + this.chord + " volume=" + this.volume;
    }
}

