/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.CU;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.PolygonFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class EfvetReader
extends PolygonFileReader {
    private int[] vertexMap;

    EfvetReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2PFR(sg, br);
        this.jvxlFileHeaderBuffer.append("efvet file format\nvertices and triangles only\n");
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
        this.hasColorData = true;
    }

    @Override
    void getSurfaceData() throws Exception {
        this.getHeader();
        this.getVertices();
        this.getTriangles();
        Logger.info((String)("efvet file contains " + this.nVertices + " vertices and " + this.nTriangles + " triangles"));
    }

    private void getHeader() throws Exception {
        this.skipTo("<efvet", null);
        while (this.rd().length() > 0 && this.line.indexOf(">") < 0) {
            this.jvxlFileHeaderBuffer.append("# " + this.line + "\n");
        }
        Logger.info((String)this.jvxlFileHeaderBuffer.toString());
    }

    private void getVertices() throws Exception {
        P3 pt = new P3();
        float value = 0.0f;
        this.skipTo("<vertices", "count");
        this.jvxlData.vertexCount = this.nVertices = this.parseInt();
        this.vertexMap = new int[this.nVertices + 1];
        this.jvxlData.vertexColors = null;
        if (this.params.fileIndex == 0) {
            this.jvxlData.vertexColors = new int[this.nVertices];
            this.jvxlData.nVertexColors = 0;
        }
        float[] values = new float[this.jvxlData.vertexColors == null ? 3 : 9];
        this.skipTo("property=", null);
        this.line = this.line.replace('\"', ' ');
        String[] tokens = this.getTokens();
        int dataIndex = this.params.fileIndex;
        if (dataIndex > 0 && dataIndex < tokens.length) {
            Logger.info((String)("property " + tokens[dataIndex]));
        } else {
            Logger.info((String)this.line);
        }
        for (int i = 0; i < this.nVertices; ++i) {
            int v;
            this.skipTo("<vertex", "image");
            this.parseFloatArray(values, null, ">");
            pt.set(values[0], values[1], values[2]);
            this.skipTo(null, "property");
            for (int j = 0; j < dataIndex; ++j) {
                value = this.parseFloat();
            }
            if (this.isAnisotropic) {
                this.setVertexAnisotropy((T3)pt);
            }
            if ((v = (this.vertexMap[i + 1] = this.addVC((T3)pt, value, i, true))) < 0 || this.jvxlData.vertexColors == null) continue;
            this.jvxlData.vertexColors[v] = CU.colorTriadToFFRGB((float)values[6], (float)values[7], (float)values[8]);
            ++this.jvxlData.nVertexColors;
        }
    }

    private void getTriangles() throws Exception {
        this.skipTo("<triangle_array", "count");
        this.nTriangles = this.parseInt();
        for (int i = 0; i < this.nTriangles; ++i) {
            this.skipTo("<triangle", "vertex");
            int a = this.getInt();
            int b = this.getInt();
            int c = this.getInt();
            if (a < 0 || b < 0 || c < 0) continue;
            this.addTriangleCheck(a, b, c, 7, 0, false, 0);
        }
    }

    private int getInt() {
        return this.vertexMap[this.parseInt()];
    }
}

