/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.io.File;
import java.io.IOException;
import org.jmol.util.Logger;
import org.openscience.jmol.app.nbo.NBOService;

class NBOJob {
    NBOService service;
    long startTime;
    Runnable process;
    String name;
    String statusInfo;
    String err;
    String errFile;

    NBOJob(NBOService service, String name, String statusInfo, Runnable process) {
        this.service = service;
        this.name = name;
        this.statusInfo = statusInfo;
        this.process = process;
        this.errFile = service.serverDir + "/nboerr$$.dat";
    }

    public void run() {
        File f;
        this.startTime = System.currentTimeMillis();
        if (this.service.nboDialog != null) {
            this.service.nboDialog.setStatus(this.statusInfo);
        }
        Logger.info("NBO job " + this.name + " started");
        this.process.run();
        if (this.service.nboDialog != null) {
            this.service.nboDialog.setStatus(null);
        }
        if ((f = new File(this.errFile)).length() > 0L) {
            String error = this.service.getFileData(this.errFile);
            this.service.nboDialog.showErrorFile(this.errFile);
            try {
                this.service.writeToFile("", new File(this.errFile));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Logger.info("NBO job " + this.name + " ended ms:" + (System.currentTimeMillis() - this.startTime));
    }
}

