/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javajs.J2SIgnoreImport;
import javajs.util.JSONException;
import javajs.util.Lst;
import javajs.util.SB;

@J2SIgnoreImport(value={HashMap.class})
public class JSJSONParser {
    private String str;
    private int index;
    private int len;
    private boolean asHashTable;

    public Map<String, Object> parseMap(String string, boolean bl) {
        this.index = 0;
        this.asHashTable = bl;
        this.str = string;
        this.len = string.length();
        if (this.getChar() != '{') {
            return null;
        }
        this.returnChar();
        return (Map)this.getValue(false);
    }

    public Object parse(String string) {
        this.index = 0;
        this.str = string;
        this.len = string.length();
        return this.getValue(false);
    }

    private char next() {
        return this.index < this.len ? this.str.charAt(this.index++) : (char)'\u0000';
    }

    private void returnChar() {
        --this.index;
    }

    private char getChar() throws JSONException {
        char c;
        while ((c = this.next()) != '\u0000' && c <= ' ') {
        }
        return c;
    }

    private Object getValue(boolean bl) throws JSONException {
        int n = this.index;
        char c = this.getChar();
        switch (c) {
            case '\u0000': {
                return null;
            }
            case '\"': 
            case '\'': {
                return this.getString(c);
            }
            case '{': {
                if (!bl) {
                    return this.getObject();
                }
                c = '\u0000';
                break;
            }
            case '[': {
                if (!bl) {
                    return this.getArray();
                }
                c = '\u0000';
                break;
            }
            default: {
                this.returnChar();
                while (c >= ' ' && "[,]{:}'\"".indexOf(c) < 0) {
                    c = this.next();
                }
                this.returnChar();
                if (!bl || c == ':') break;
                c = '\u0000';
            }
        }
        if (bl && c == '\u0000') {
            throw new JSONException("invalid key");
        }
        String string = this.str.substring(n, this.index);
        if (!bl) {
            if (string.equals("true")) {
                return Boolean.TRUE;
            }
            if (string.equals("false")) {
                return Boolean.FALSE;
            }
            if (string.equals("null")) {
                return this.asHashTable ? string : null;
            }
        }
        if ((c = string.charAt(0)) >= '0' && c <= '9' || c == '-') {
            try {
                if (string.indexOf(46) < 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
                    return new Integer(string);
                }
                Float f = Float.valueOf(string);
                if (!f.isInfinite() && !f.isNaN()) {
                    return f;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("JSON parser cannot parse " + string);
        throw new JSONException("invalid value");
    }

    private String getString(char c) throws JSONException {
        SB sB = null;
        int n = this.index;
        while (true) {
            int n2 = this.index;
            char c2 = this.next();
            block1 : switch (c2) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c2 = this.next();
                    switch (c2) {
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            break block1;
                        }
                        case 'b': {
                            c2 = '\b';
                            break block1;
                        }
                        case 't': {
                            c2 = '\t';
                            break block1;
                        }
                        case 'n': {
                            c2 = '\n';
                            break block1;
                        }
                        case 'f': {
                            c2 = '\f';
                            break block1;
                        }
                        case 'r': {
                            c2 = '\r';
                            break block1;
                        }
                        case 'u': {
                            int n3 = this.index;
                            this.index += 4;
                            try {
                                c2 = (char)Integer.parseInt(this.str.substring(n3, this.index), 16);
                                break block1;
                            }
                            catch (Exception exception) {
                                throw this.syntaxError("Substring bounds error");
                            }
                        }
                    }
                    throw this.syntaxError("Illegal escape.");
                }
                default: {
                    if (c2 != c) break;
                    return sB == null ? this.str.substring(n, n2) : sB.toString();
                }
            }
            if (this.index > n2 + 1 && sB == null) {
                sB = new SB();
                sB.append(this.str.substring(n, n2));
            }
            if (sB == null) continue;
            sB.appendC(c2);
        }
    }

    private Object getObject() {
        Map map = this.asHashTable ? new Hashtable() : new HashMap();
        String string = null;
        switch (this.getChar()) {
            case '}': {
                return map;
            }
            case '\u0000': {
                throw new JSONException("invalid object");
            }
        }
        this.returnChar();
        boolean bl = false;
        block9: while (true) {
            if (bl = !bl) {
                string = this.getValue(true).toString();
            } else {
                map.put(string, this.getValue(false));
            }
            switch (this.getChar()) {
                case '}': {
                    return map;
                }
                case ':': {
                    if (bl) continue block9;
                    bl = true;
                }
                case ',': {
                    if (bl) break block9;
                    continue block9;
                }
            }
            break;
        }
        throw this.syntaxError("Expected ',' or ':' or '}'");
    }

    private Object getArray() {
        Lst<Object> lst = new Lst<Object>();
        switch (this.getChar()) {
            case ']': {
                return lst;
            }
            case '\u0000': {
                throw new JSONException("invalid array");
            }
        }
        this.returnChar();
        boolean bl = false;
        block12: while (true) {
            if (bl) {
                lst.addLast((Object)null);
                bl = false;
            } else {
                lst.addLast(this.getValue(false));
            }
            switch (this.getChar()) {
                case ',': {
                    switch (this.getChar()) {
                        case ']': {
                            return lst;
                        }
                        case ',': {
                            bl = true;
                        }
                    }
                    this.returnChar();
                    continue block12;
                }
                case ']': {
                    return lst;
                }
            }
            break;
        }
        throw this.syntaxError("Expected ',' or ']'");
    }

    public JSONException syntaxError(String string) {
        return new JSONException(string + " for " + this.str.substring(0, Math.min(this.index, this.len)));
    }
}

