/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import java.util.Hashtable;
import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class FoldingXyzReader
extends AtomSetCollectionReader {
    protected void initializeReader() {
    }

    protected void finalizeSubclassReader() throws Exception {
        if (this.asc.bondCount > 0) {
            this.asc.setNoAutoBond();
        }
        this.isTrajectory = false;
        this.finalizeReaderASCR();
    }

    protected boolean checkLine() throws Exception {
        int[] next = new int[]{0};
        String token = PT.parseTokenNext((String)this.line, (int[])next);
        if (token == null) {
            return true;
        }
        boolean addAtoms = this.doGetModel(++this.modelNumber, null);
        int modelAtomCount = this.parseIntStr(token);
        if (addAtoms) {
            this.asc.newAtomSet();
            String[] tokens = this.getTokens();
            this.asc.setAtomSetName(tokens.length == 2 ? "Protein " + tokens[1] : this.line.substring(next[0]).trim());
        }
        boolean readLine = this.readAtoms(modelAtomCount + 1, addAtoms);
        this.continuing = !addAtoms || !this.isLastModel(this.modelNumber);
        return readLine;
    }

    boolean readAtoms(int ac, boolean addAtoms) throws Exception {
        Hashtable<String, int[]> htBondCounts = new Hashtable<String, int[]>();
        String[][] bonds = new String[ac][];
        boolean haveAtomTypes = true;
        boolean checking = true;
        String lastAtom = null;
        boolean readNextLine = true;
        for (int i = 0; i < ac; ++i) {
            this.discardLinesUntilNonBlank();
            if (this.line == null) break;
            String[] tokens = this.getTokens();
            String sIndex = tokens[0];
            if (sIndex.equals(lastAtom)) {
                readNextLine = false;
                break;
            }
            lastAtom = sIndex;
            if (!addAtoms) continue;
            Atom atom = new Atom();
            atom.atomName = tokens[1];
            atom.elementSymbol = this.getElement(tokens[1]);
            atom.atomSerial = this.parseIntStr(sIndex);
            if (!this.filterAtom(atom, i)) continue;
            this.setAtomCoordTokens(atom, tokens, 2);
            this.asc.addAtomWithMappedSerialNumber(atom);
            int n = tokens.length - 5;
            bonds[i] = new String[n + 1];
            bonds[i][n] = sIndex;
            for (int j = 0; j < n; ++j) {
                String t = tokens[j + 5];
                int i2 = this.parseIntStr(t);
                bonds[i][j] = t;
                if (!checking) continue;
                if (n == 0 || t.equals(sIndex) || i2 <= 0 || i2 > ac) {
                    haveAtomTypes = n > 0;
                    checking = false;
                    continue;
                }
                int[] count = (int[])htBondCounts.get(t);
                if (count == null) {
                    count = new int[1];
                    htBondCounts.put(t, count);
                }
                if ((count[0] = count[0] + 1) <= 10) continue;
                checking = false;
                haveAtomTypes = !false;
            }
        }
        if (addAtoms) {
            this.makeBonds(bonds, !checking && haveAtomTypes);
            this.applySymmetryAndSetTrajectory();
        }
        return readNextLine;
    }

    private void makeBonds(String[][] bonds, boolean haveAtomTypes) {
        int i = bonds.length;
        while (--i >= 0) {
            String[] b = bonds[i];
            if (b == null) continue;
            Atom a1 = this.asc.getAtomFromName(b[b.length - 1]);
            int b0 = 0;
            if (haveAtomTypes) {
                a1.atomName = a1.atomName + "\u0000" + b[b0++];
            }
            int j = b.length - 1;
            while (--j >= b0) {
                Atom a2 = this.asc.getAtomFromName(b[j]);
                if (a1.index >= a2.index) continue;
                this.asc.addNewBondWithOrderA(a1, a2, 1);
            }
        }
    }

    private String getElement(String name) {
        int n = name.length();
        switch (n) {
            case 1: {
                break;
            }
            default: {
                char c1 = name.charAt(0);
                char c2 = name.charAt(1);
                n = Atom.isValidSym2((char)c1, (char)c2) || c1 == 'C' && c2 == 'L' ? 2 : 1;
            }
        }
        return name.substring(0, n);
    }
}

