/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.readers.xml.XmlCmlReader;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.quantum.QS;
import org.jmol.util.Logger;

public abstract class XmlMOReader
extends XmlCmlReader {
    private MOReader moReader;
    private boolean skipMOs;
    private Map<String, int[]> htSlaterIDs;
    private Lst<float[]> basisData;
    private String basisId;
    private boolean isSpherical;
    private int minL;
    private int maxL;
    private String[] basisIds;
    private String[] basisAtoms;
    private float orbOcc;
    private float orbEnergy;
    private int gaussianCount;
    private int slaterCount;
    private int coefCount;
    private int groupCount;
    private Lst<Lst<float[]>> lstGaussians;
    private int moCount;
    private String calcType;
    private int iModelMO;
    protected String dclist;
    protected String dslist;
    protected String fclist;
    protected String fslist;
    protected boolean iHaveCoefMaps;
    private int maxContraction;

    @Override
    protected void processXml(XmlReader parent, Object saxReader) throws Exception {
        this.htModelAtomMap = new Hashtable();
        this.processXml2(parent, saxReader);
    }

    protected boolean processStartMO(String localName) {
        if (!this.parent.doReadMolecularOrbitals) {
            return false;
        }
        if (localName.equals("molecule")) {
            String method = (String)this.atts.get("method");
            if (method != null) {
                this.calcType = method + "(" + (String)this.atts.get("basis") + ")";
            }
            return true;
        }
        if (localName.equals("basisset")) {
            this.iModelMO = this.asc.iSet;
            this.lstGaussians = new Lst();
            this.htSlaterIDs = new Hashtable<String, int[]>();
            this.slaterCount = 0;
            this.gaussianCount = 0;
            this.groupCount = 0;
            this.coefCount = 0;
            if (this.moReader == null && !this.skipMOs) {
                Object rdr = Resolver.getReader((String)"MO", (Map)this.parent.htParams);
                if (rdr instanceof String) {
                    this.skipMOs = true;
                } else {
                    this.moReader = (MOReader)rdr;
                    this.moReader.asc = this.asc;
                    if (this.iHaveCoefMaps) {
                        int[][] m = this.moReader.getDfCoefMaps();
                        if (this.dclist != null) {
                            QS.createDFMap((int[])m[4], (String)this.dclist, (String)"DXX   DYY   DZZ   DXY   DXZ   DYZ", (int)2);
                        }
                        if (this.dslist != null) {
                            QS.createDFMap((int[])m[3], (String)this.dslist, (String)"d0    d1+   d1-   d2+   d2-", (int)2);
                        }
                        if (this.fclist != null) {
                            QS.createDFMap((int[])m[6], (String)this.fclist, (String)"XXX   YYY   ZZZ   XYY   XXY   XXZ   XZZ   YZZ   YYZ   XYZ", (int)2);
                        }
                        if (this.fslist != null) {
                            QS.createDFMap((int[])m[5], (String)this.fslist, (String)"f0    f1+   f1-   f2+   f2-   f3+   f3-", (int)2);
                        }
                    }
                }
            }
            if (this.moReader != null) {
                this.moReader.calculationType = this.calcType;
            }
            return true;
        }
        if (this.moReader != null) {
            if (localName.equals("basisgroup")) {
                ++this.groupCount;
                this.basisId = (String)this.atts.get("id");
                this.isSpherical = "spherical".equalsIgnoreCase((String)this.atts.get("angular"));
                this.minL = PT.parseInt((String)((String)this.atts.get("minl")));
                this.maxL = PT.parseInt((String)((String)this.atts.get("maxl")));
                int nContractions = PT.parseInt((String)((String)this.atts.get("contractions")));
                int n = nContractions * (this.isSpherical ? this.minL * 2 + 1 : this.minL * (this.minL + 3) / 2 + 1);
                this.htModelAtomMap.put(this.basisId + "_count", n);
                return true;
            }
            if (localName.equals("basisexponents") || localName.equals("basiscontraction")) {
                this.setKeepChars(true);
                return true;
            }
            if (localName.equals("orbital") && this.gaussianCount > 0) {
                this.orbOcc = PT.parseFloat((String)((String)this.atts.get("occupation")));
                this.orbEnergy = PT.parseFloat((String)((String)this.atts.get("energy")));
                this.setKeepChars(true);
                return true;
            }
        }
        return false;
    }

    protected boolean processEndMO(String localName) {
        if (this.moReader != null) {
            if (localName.equals("basisexponents")) {
                this.basisData = new Lst();
                this.basisData.addLast((Object)PT.parseFloatArray((String)this.chars.toString()));
                this.setKeepChars(false);
                return true;
            }
            if (localName.equals("basiscontraction")) {
                float[] data = PT.parseFloatArray((String)this.chars.toString());
                this.basisData.addLast((Object)data);
                if (this.basisData.size() > this.maxContraction) {
                    this.maxContraction = this.basisData.size();
                }
                this.setKeepChars(false);
                return true;
            }
            if (localName.equals("basisgroup")) {
                String otype;
                switch (this.minL) {
                    case 0: {
                        otype = this.maxL == 1 ? "L" : "S";
                        break;
                    }
                    case 1: {
                        otype = "P";
                        break;
                    }
                    default: {
                        String string = otype = this.minL <= 7 ? "SPDFGHI".substring(this.minL, this.minL + 1) : "?";
                        if (!this.isSpherical) break;
                        otype = 2 * this.minL + 1 + otype;
                    }
                }
                this.lstGaussians.addLast(this.basisData);
                int nPrimitives = ((float[])this.basisData.get(0)).length;
                int n = this.basisData.size();
                for (int i = 1; i < n; ++i) {
                    int[] nArray = new int[4];
                    nArray[0] = -1;
                    nArray[1] = MOReader.getQuantumShellTagID((String)otype);
                    nArray[2] = this.gaussianCount;
                    nArray[3] = nPrimitives;
                    this.htSlaterIDs.put(this.basisId + "_" + i, nArray);
                    this.gaussianCount += nPrimitives;
                }
                return true;
            }
            if (localName.equals("basisset")) {
                this.buildSlaters();
                return true;
            }
            if (localName.equals("orbital")) {
                if (this.gaussianCount == 0) {
                    return true;
                }
                float[] coef = PT.parseFloatArray((String)this.chars.toString());
                if (this.moCount == 0) {
                    if (coef.length != this.coefCount) {
                        Logger.error((String)("Number of orbital coefficients (" + coef.length + ") does not agree with expected number (" + this.coefCount + ")"));
                        this.moReader = null;
                        this.skipMOs = true;
                        return true;
                    }
                    Logger.info((String)(this.coefCount + " coefficients found"));
                }
                this.moReader.addCoef(new Hashtable(), coef, null, this.orbEnergy, this.orbOcc, this.moCount++);
                this.setKeepChars(false);
                return true;
            }
            if (localName.equals("orbitals")) {
                this.moReader.setMOData(true);
                Logger.info((String)("XmlMOReader created\n " + this.gaussianCount + " gaussians\n " + this.slaterCount + " slaters\n " + this.groupCount + " groups\n " + this.coefCount + " orbital coefficients\n " + this.moCount + " orbitals"));
                return true;
            }
            if (this.state == 19) {
                if (localName.equals("bases")) {
                    this.basisIds = this.getXlink((String)this.atts.get("href"), "basisGroup", false);
                } else if (localName.equals("atoms")) {
                    this.basisAtoms = this.getXlink((String)this.atts.get("href"), "atom", true);
                } else if (localName.equals("association")) {
                    this.state = 6;
                    int i = this.basisAtoms.length;
                    while (--i >= 0) {
                        Atom a = (Atom)this.htModelAtomMap.get(this.basisAtoms[i]);
                        if (a == null) {
                            Logger.error((String)("XmlMOReader atom not found; orbitals skipped: " + a));
                            this.moReader = null;
                            this.skipMOs = true;
                            return true;
                        }
                        this.htModelAtomMap.put(this.basisAtoms[i] + "_basis", this.basisIds);
                    }
                    this.slaterCount += this.basisIds.length * this.basisAtoms.length;
                }
                return true;
            }
        }
        return false;
    }

    private void buildSlaters() {
        float[][] gaussians = AU.newFloat2((int)this.gaussianCount);
        int p = 0;
        int n = this.lstGaussians.size();
        for (int i = 0; i < n; ++i) {
            this.basisData = (Lst)this.lstGaussians.get(i);
            float[] exp = (float[])this.basisData.get(0);
            int nn = this.basisData.size();
            for (int ii = 1; ii < nn; ++ii) {
                float[] coef = (float[])this.basisData.get(ii);
                for (int j = 0; j < exp.length; ++j) {
                    gaussians[p++] = new float[]{exp[j], coef[j], 0.0f};
                }
            }
        }
        this.moReader.gaussians = gaussians;
        Lst slaters = new Lst();
        String modelID = (String)this.htModelAtomMap.get("" + this.iModelMO);
        int i0 = this.asc.getAtomSetAtomIndex(this.iModelMO);
        int n2 = this.asc.getAtomSetAtomCount(this.iModelMO);
        for (int i = 0; i < n2; ++i) {
            String[] ids = (String[])this.htModelAtomMap.get(modelID + this.asc.atoms[i0 + i].atomName + "_basis");
            if (ids == null) continue;
            for (int k = 0; k < ids.length; ++k) {
                int[] slater;
                String key = ids[k] + "_count";
                this.coefCount += ((Integer)this.htModelAtomMap.get(key)).intValue();
                for (int kk = 1; kk < this.maxContraction && (slater = this.htSlaterIDs.get(ids[k] + "_" + kk)) != null; ++kk) {
                    slater = AU.arrayCopyI((int[])slater, (int)-1);
                    this.moReader.shells = slaters;
                    slater[0] = i;
                    slaters.addLast((Object)slater);
                }
            }
        }
    }

    private String[] getXlink(String href, String key, boolean addMoleculeID) {
        int p = href.indexOf(key + "[") + 1;
        String[] tokens = PT.split((String)href.substring(p), (String)"'");
        String[] data = new String[tokens.length / 2];
        String molID = addMoleculeID ? PT.getQuotedAttribute((String)href.substring(0, p).replace('\'', '\"'), (String)"molecule[@id") : "";
        int pt = 0;
        for (int i = 1; i < tokens.length; i += 2) {
            data[pt++] = molID + tokens[i];
        }
        return data;
    }
}

