/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.CalculationsMMFF;

class MMFFOOPCalc
extends Calculation {
    static final double FOOPD = 2.5120761569715815;
    static final double FOOP = 71.96568080495746;
    int[] list = new int[4];

    MMFFOOPCalc() {
    }

    void setData(Lst<Object[]> calc, int i) {
        if (this.calcs.minAtoms[i].nBonds != 3) {
            return;
        }
        int[] indices = this.calcs.minAtoms[i].getBondedAtomIndexes();
        this.list[0] = indices[2];
        this.list[1] = i;
        this.list[2] = indices[1];
        this.list[3] = indices[0];
        double koop = ((CalculationsMMFF)this.calcs).mmff.getOutOfPlaneParameter(this.list);
        if (koop == 0.0) {
            return;
        }
        double[] dk = new double[]{koop};
        calc.addLast((Object)new Object[]{new int[]{indices[0], i, indices[1], indices[2]}, dk});
        calc.addLast((Object)new Object[]{new int[]{indices[1], i, indices[2], indices[0]}, dk});
        calc.addLast((Object)new Object[]{new int[]{indices[2], i, indices[0], indices[1]}, dk});
    }

    @Override
    double compute(Object[] dataIn) {
        this.getPointers(dataIn);
        this.calcs.setOopVariables(this, false);
        double koop = this.dData[0];
        this.energy = 71.96568080495746 * koop * this.theta * this.theta;
        if (this.calcs.gradients) {
            this.dE = 2.5120761569715815 * koop * this.theta;
            this.calcs.addForces(this, 4);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(4, this));
        }
        return this.energy;
    }
}

