/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.io.BufferedInputStream;
import java.io.IOException;
import javajs.util.Rdr;

public class BMPDecoder {
    private BufferedInputStream bis;
    private byte[] temp;

    public Object[] decodeWindowsBMP(byte[] byArray) {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            this.bis = Rdr.getBIS(byArray);
            this.temp = new byte[4];
            if (this.readByte() != 66 || this.readByte() != 77) {
                return null;
            }
            this.readInt();
            this.readShort();
            this.readShort();
            this.readInt();
            int n5 = 0;
            int n6 = 0;
            int n7 = this.readInt();
            switch (n7) {
                case 12: {
                    n4 = this.readShort();
                    n3 = this.readShort();
                    this.readShort();
                    n2 = this.readShort();
                    break;
                }
                case 40: {
                    n4 = this.readInt();
                    n3 = this.readInt();
                    this.readShort();
                    n2 = this.readShort();
                    n = this.readInt();
                    if (n != 0) {
                        System.out.println("BMP Compression is :" + n + " -- aborting");
                        return null;
                    }
                    n6 = this.readInt();
                    this.readInt();
                    this.readInt();
                    n5 = this.readInt();
                    this.readInt();
                    break;
                }
                default: {
                    System.out.println("BMP Header unrecognized, length=" + n7 + " -- aborting");
                    return null;
                }
            }
            int n8 = n = n3 < 0 ? 1 : 0;
            if (n != 0) {
                n3 = -n3;
            }
            int n9 = n3 * n4;
            int n10 = n2 / 8;
            int n11 = n5 = n5 > 0 ? n5 : 1 << n2;
            int n12 = (n10 == 4 ? 0 : (n6 == 0 ? 4 - n4 % 4 : n6 / n3 - n4 * n10)) % 4;
            int[] nArray = new int[n9];
            int n13 = n != 0 ? n4 : -n4;
            int n14 = n != 0 ? 0 : n9 + n13;
            int n15 = n != 0 ? n9 : n13;
            switch (n2) {
                case 24: 
                case 32: {
                    for (int i = n14; i != n15; i += n13) {
                        for (int j = 0; j < n4; ++j) {
                            nArray[i + j] = this.readColor(n10);
                        }
                        this.pad(n12);
                    }
                    break;
                }
                case 8: {
                    int n16;
                    int[] nArray2 = new int[n5];
                    for (n16 = 0; n16 < n5; ++n16) {
                        nArray2[n16] = this.readColor(4);
                    }
                    for (n16 = n14; n16 != n15; n16 += n13) {
                        for (int i = 0; i < n4; ++i) {
                            nArray[n16 + i] = nArray2[this.readByte()];
                        }
                        this.pad(n12);
                    }
                    break;
                }
                case 4: {
                    int n17;
                    n12 = (4 - (n4 + 1) / 2 % 4) % 4;
                    int[] nArray3 = new int[n5];
                    for (n17 = 0; n17 < n5; ++n17) {
                        nArray3[n17] = this.readColor(4);
                    }
                    n17 = 0;
                    for (int i = n14; i != n15; i += n13) {
                        int n18 = 0;
                        int n19 = 4;
                        while (n18 < n4) {
                            nArray[i + n18] = nArray3[(n19 == 4 ? this.readByte() : n17) >> n19 & 0xF];
                            ++n18;
                            n19 = 4 - n19;
                        }
                        this.pad(n12);
                    }
                    break;
                }
                case 1: {
                    int n20 = this.readColor(3);
                    int n21 = this.readColor(3);
                    n12 = (4 - (n4 + 7) / 8 % 4) % 4;
                    int n22 = 0;
                    for (int i = n14; i != n15; i += n13) {
                        int n23 = 0;
                        int n24 = -1;
                        while (n23 < n4) {
                            if (n24 < 0) {
                                n22 = this.readByte();
                                n24 = 7;
                            }
                            nArray[i + n23] = (n22 & 1 << n24) == 0 ? n20 : n21;
                            ++n23;
                            --n24;
                        }
                        this.pad(n12);
                    }
                    break;
                }
                default: {
                    System.out.println("Not a 32-, 24-, 8-, 4-, or 1-bit Windows Bitmap, aborting...");
                    return null;
                }
            }
            return new Object[]{nArray, n4, n3};
        }
        catch (Exception exception) {
            System.out.println("Caught exception in loadbitmap!");
            return null;
        }
    }

    private boolean pad(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.readByte();
        }
        return true;
    }

    private int readColor(int n) throws IOException {
        this.bis.read(this.temp, 0, n);
        return 0xFF000000 | (this.temp[2] & 0xFF) << 16 | (this.temp[1] & 0xFF) << 8 | this.temp[0] & 0xFF;
    }

    private int readInt() throws IOException {
        this.bis.read(this.temp, 0, 4);
        return (this.temp[3] & 0xFF) << 24 | (this.temp[2] & 0xFF) << 16 | (this.temp[1] & 0xFF) << 8 | this.temp[0] & 0xFF;
    }

    private int readShort() throws IOException {
        this.bis.read(this.temp, 0, 2);
        return (this.temp[1] & 0xFF) << 8 | this.temp[0] & 0xFF;
    }

    private int readByte() throws IOException {
        this.bis.read(this.temp, 0, 1);
        return this.temp[0] & 0xFF;
    }
}

