/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;

public class Tag {
    private final int _tagType;
    @NotNull
    private final Directory _directory;

    public Tag(int n, @NotNull Directory directory) {
        this._tagType = n;
        this._directory = directory;
    }

    public int getTagType() {
        return this._tagType;
    }

    @NotNull
    public String getTagTypeHex() {
        String string = Integer.toHexString(this._tagType);
        while (string.length() < 4) {
            string = "0" + string;
        }
        return "0x" + string;
    }

    @Nullable
    public String getDescription() {
        return this._directory.getDescription(this._tagType);
    }

    @NotNull
    public boolean hasTagName() {
        return this._directory.hasTagName(this._tagType);
    }

    @NotNull
    public String getTagName() {
        return this._directory.getTagName(this._tagType);
    }

    @NotNull
    public String getDirectoryName() {
        return this._directory.getName();
    }

    @NotNull
    public String toString() {
        String string = this.getDescription();
        if (string == null) {
            string = this._directory.getString(this.getTagType()) + " (unable to formulate description)";
        }
        return "[" + this._directory.getName() + "] " + this.getTagName() + " - " + string;
    }
}

