/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.SVGUniverse;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SVGDiagram
implements Serializable {
    public static final long serialVersionUID = 0L;
    final HashMap idMap = new HashMap();
    SVGRoot root;
    final SVGUniverse universe;
    private Rectangle deviceViewport = new Rectangle(100, 100);
    protected boolean ignoreClipHeuristic = false;
    final URI xmlBase;

    public SVGDiagram(URI uRI, SVGUniverse sVGUniverse) {
        this.universe = sVGUniverse;
        this.xmlBase = uRI;
    }

    public void render(Graphics2D graphics2D) throws SVGException {
        this.root.renderToViewport(graphics2D);
    }

    public List pick(Point2D point2D, List list) throws SVGException {
        return this.pick(point2D, false, list);
    }

    public List pick(Point2D point2D, boolean bl, List arrayList) throws SVGException {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this.root.pick(point2D, bl, arrayList);
        return arrayList;
    }

    public List pick(Rectangle2D rectangle2D, List list) throws SVGException {
        return this.pick(rectangle2D, false, list);
    }

    public List pick(Rectangle2D rectangle2D, boolean bl, List arrayList) throws SVGException {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        this.root.pick(rectangle2D, new AffineTransform(), bl, arrayList);
        return arrayList;
    }

    public SVGUniverse getUniverse() {
        return this.universe;
    }

    public URI getXMLBase() {
        return this.xmlBase;
    }

    public float getWidth() {
        if (this.root == null) {
            return 0.0f;
        }
        return this.root.getDeviceWidth();
    }

    public float getHeight() {
        if (this.root == null) {
            return 0.0f;
        }
        return this.root.getDeviceHeight();
    }

    public Rectangle2D getViewRect(Rectangle2D rectangle2D) {
        if (this.root != null) {
            return this.root.getDeviceRect(rectangle2D);
        }
        return rectangle2D;
    }

    public Rectangle2D getViewRect() {
        return this.getViewRect(new Rectangle2D.Double());
    }

    public SVGElement getElement(String string) {
        return (SVGElement)this.idMap.get(string);
    }

    public void setElement(String string, SVGElement sVGElement) {
        this.idMap.put(string, sVGElement);
    }

    public void removeElement(String string) {
        this.idMap.remove(string);
    }

    public SVGRoot getRoot() {
        return this.root;
    }

    public void setRoot(SVGRoot sVGRoot) {
        this.root = sVGRoot;
        sVGRoot.setDiagram(this);
    }

    public boolean ignoringClipHeuristic() {
        return this.ignoreClipHeuristic;
    }

    public void setIgnoringClipHeuristic(boolean bl) {
        this.ignoreClipHeuristic = bl;
    }

    public void updateTime(double d) throws SVGException {
        if (this.root == null) {
            return;
        }
        this.root.updateTime(d);
    }

    public Rectangle getDeviceViewport() {
        return this.deviceViewport;
    }

    public void setDeviceViewport(Rectangle rectangle) {
        this.deviceViewport.setBounds(rectangle);
        if (this.root != null) {
            try {
                this.root.build();
            }
            catch (SVGException sVGException) {
                Logger.getLogger("svgSalamandeLogger").log(Level.WARNING, "Could not build document", sVGException);
            }
        }
    }
}

