/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventHandler;

public class ElementAttributes
implements IElementAttributes {
    private static final long serialVersionUID = 7814990748035017441L;
    private boolean IS_SPOOL = true;
    private boolean IS_LATERAL = true;
    private boolean IS_REMOTE = true;
    private boolean IS_ETERNAL = true;
    private long maxLife = -1L;
    private long maxIdleTime = -1L;
    private int size = 0;
    private long createTime = 0L;
    private long lastAccessTime = 0L;
    private transient ArrayList<IElementEventHandler> eventHandlers;
    private long timeFactor = 1000L;

    public ElementAttributes() {
        this.lastAccessTime = this.createTime = System.currentTimeMillis();
    }

    protected ElementAttributes(ElementAttributes elementAttributes) {
        this.IS_ETERNAL = elementAttributes.IS_ETERNAL;
        this.IS_SPOOL = elementAttributes.IS_SPOOL;
        this.IS_LATERAL = elementAttributes.IS_LATERAL;
        this.IS_REMOTE = elementAttributes.IS_REMOTE;
        this.maxLife = elementAttributes.maxLife;
        this.maxIdleTime = elementAttributes.maxIdleTime;
        this.size = elementAttributes.size;
    }

    @Override
    public void setMaxLife(long l) {
        this.maxLife = l;
    }

    @Override
    public long getMaxLife() {
        return this.maxLife;
    }

    @Override
    public void setIdleTime(long l) {
        this.maxIdleTime = l;
    }

    @Override
    public void setSize(int n) {
        this.size = n;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime() {
        this.createTime = System.currentTimeMillis();
    }

    @Override
    public long getIdleTime() {
        return this.maxIdleTime;
    }

    @Override
    public long getTimeToLiveSeconds() {
        long l = System.currentTimeMillis();
        long l2 = this.getTimeFactorForMilliseconds();
        return (this.getCreateTime() + this.getMaxLife() * l2 - l) / 1000L;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void setLastAccessTimeNow() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public void setLastAccessTime(long l) {
        this.lastAccessTime = l;
    }

    @Override
    public boolean getIsSpool() {
        return this.IS_SPOOL;
    }

    @Override
    public void setIsSpool(boolean bl) {
        this.IS_SPOOL = bl;
    }

    @Override
    public boolean getIsLateral() {
        return this.IS_LATERAL;
    }

    @Override
    public void setIsLateral(boolean bl) {
        this.IS_LATERAL = bl;
    }

    @Override
    public boolean getIsRemote() {
        return this.IS_REMOTE;
    }

    @Override
    public void setIsRemote(boolean bl) {
        this.IS_REMOTE = bl;
    }

    @Override
    public boolean getIsEternal() {
        return this.IS_ETERNAL;
    }

    @Override
    public void setIsEternal(boolean bl) {
        this.IS_ETERNAL = bl;
    }

    @Override
    public void addElementEventHandler(IElementEventHandler iElementEventHandler) {
        if (this.eventHandlers == null) {
            this.eventHandlers = new ArrayList();
        }
        this.eventHandlers.add(iElementEventHandler);
    }

    @Override
    public void addElementEventHandlers(List<IElementEventHandler> list) {
        if (list == null) {
            return;
        }
        for (IElementEventHandler iElementEventHandler : list) {
            this.addElementEventHandler(iElementEventHandler);
        }
    }

    @Override
    public long getTimeFactorForMilliseconds() {
        return this.timeFactor;
    }

    @Override
    public void setTimeFactorForMilliseconds(long l) {
        this.timeFactor = l;
    }

    @Override
    public ArrayList<IElementEventHandler> getElementEventHandlers() {
        return this.eventHandlers;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ IS_LATERAL = ").append(this.IS_LATERAL);
        stringBuilder.append(", IS_SPOOL = ").append(this.IS_SPOOL);
        stringBuilder.append(", IS_REMOTE = ").append(this.IS_REMOTE);
        stringBuilder.append(", IS_ETERNAL = ").append(this.IS_ETERNAL);
        stringBuilder.append(", MaxLifeSeconds = ").append(this.getMaxLife());
        stringBuilder.append(", IdleTime = ").append(this.getIdleTime());
        stringBuilder.append(", CreateTime = ").append(this.getCreateTime());
        stringBuilder.append(", LastAccessTime = ").append(this.getLastAccessTime());
        stringBuilder.append(", getTimeToLiveSeconds() = ").append(String.valueOf(this.getTimeToLiveSeconds()));
        stringBuilder.append(", createTime = ").append(String.valueOf(this.createTime)).append(" ]");
        return stringBuilder.toString();
    }

    @Override
    public IElementAttributes clone() {
        try {
            return (IElementAttributes)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Clone not supported. This should never happen.", cloneNotSupportedException);
        }
    }
}

