/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.glassfish.json.JsonMessages;
import org.glassfish.json.JsonNumberImpl;
import org.glassfish.json.JsonStringImpl;
import org.glassfish.json.JsonWriterImpl;
import org.glassfish.json.api.BufferPool;

class JsonObjectBuilderImpl
implements JsonObjectBuilder {
    private Map<String, JsonValue> valueMap;
    private final BufferPool bufferPool;

    JsonObjectBuilderImpl(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    @Override
    public JsonObjectBuilder add(String string, JsonValue jsonValue) {
        this.validateName(string);
        this.validateValue(jsonValue);
        this.putValueMap(string, jsonValue);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String string, String string2) {
        this.validateName(string);
        this.validateValue(string2);
        this.putValueMap(string, new JsonStringImpl(string2));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String string, BigInteger bigInteger) {
        this.validateName(string);
        this.validateValue(bigInteger);
        this.putValueMap(string, JsonNumberImpl.getJsonNumber(bigInteger));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String string, BigDecimal bigDecimal) {
        this.validateName(string);
        this.validateValue(bigDecimal);
        this.putValueMap(string, JsonNumberImpl.getJsonNumber(bigDecimal));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String string, int n) {
        this.validateName(string);
        this.putValueMap(string, JsonNumberImpl.getJsonNumber(n));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String string, long l) {
        this.validateName(string);
        this.putValueMap(string, JsonNumberImpl.getJsonNumber(l));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String string, double d) {
        this.validateName(string);
        this.putValueMap(string, JsonNumberImpl.getJsonNumber(d));
        return this;
    }

    @Override
    public JsonObjectBuilder add(String string, boolean bl) {
        this.validateName(string);
        this.putValueMap(string, bl ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    @Override
    public JsonObjectBuilder addNull(String string) {
        this.validateName(string);
        this.putValueMap(string, JsonValue.NULL);
        return this;
    }

    @Override
    public JsonObjectBuilder add(String string, JsonObjectBuilder jsonObjectBuilder) {
        this.validateName(string);
        if (jsonObjectBuilder == null) {
            throw new NullPointerException(JsonMessages.OBJBUILDER_OBJECT_BUILDER_NULL());
        }
        this.putValueMap(string, jsonObjectBuilder.build());
        return this;
    }

    @Override
    public JsonObjectBuilder add(String string, JsonArrayBuilder jsonArrayBuilder) {
        this.validateName(string);
        if (jsonArrayBuilder == null) {
            throw new NullPointerException(JsonMessages.OBJBUILDER_ARRAY_BUILDER_NULL());
        }
        this.putValueMap(string, jsonArrayBuilder.build());
        return this;
    }

    @Override
    public JsonObject build() {
        Map<String, JsonValue> map = this.valueMap == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.valueMap);
        this.valueMap = null;
        return new JsonObjectImpl(map, this.bufferPool);
    }

    private void putValueMap(String string, JsonValue jsonValue) {
        if (this.valueMap == null) {
            this.valueMap = new LinkedHashMap<String, JsonValue>();
        }
        this.valueMap.put(string, jsonValue);
    }

    private void validateName(String string) {
        if (string == null) {
            throw new NullPointerException(JsonMessages.OBJBUILDER_NAME_NULL());
        }
    }

    private void validateValue(Object object) {
        if (object == null) {
            throw new NullPointerException(JsonMessages.OBJBUILDER_VALUE_NULL());
        }
    }

    private static final class JsonObjectImpl
    extends AbstractMap<String, JsonValue>
    implements JsonObject {
        private final Map<String, JsonValue> valueMap;
        private final BufferPool bufferPool;

        JsonObjectImpl(Map<String, JsonValue> map, BufferPool bufferPool) {
            this.valueMap = map;
            this.bufferPool = bufferPool;
        }

        @Override
        public JsonArray getJsonArray(String string) {
            return (JsonArray)this.get(string);
        }

        @Override
        public JsonObject getJsonObject(String string) {
            return (JsonObject)this.get(string);
        }

        @Override
        public JsonNumber getJsonNumber(String string) {
            return (JsonNumber)this.get(string);
        }

        @Override
        public JsonString getJsonString(String string) {
            return (JsonString)this.get(string);
        }

        @Override
        public String getString(String string) {
            return this.getJsonString(string).getString();
        }

        @Override
        public String getString(String string, String string2) {
            try {
                return this.getString(string);
            }
            catch (Exception exception) {
                return string2;
            }
        }

        @Override
        public int getInt(String string) {
            return this.getJsonNumber(string).intValue();
        }

        @Override
        public int getInt(String string, int n) {
            try {
                return this.getInt(string);
            }
            catch (Exception exception) {
                return n;
            }
        }

        @Override
        public boolean getBoolean(String string) {
            JsonValue jsonValue = (JsonValue)this.get(string);
            if (jsonValue == null) {
                throw new NullPointerException();
            }
            if (jsonValue == JsonValue.TRUE) {
                return true;
            }
            if (jsonValue == JsonValue.FALSE) {
                return false;
            }
            throw new ClassCastException();
        }

        @Override
        public boolean getBoolean(String string, boolean bl) {
            try {
                return this.getBoolean(string);
            }
            catch (Exception exception) {
                return bl;
            }
        }

        @Override
        public boolean isNull(String string) {
            return ((JsonValue)this.get(string)).equals(JsonValue.NULL);
        }

        @Override
        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.OBJECT;
        }

        @Override
        public Set<Map.Entry<String, JsonValue>> entrySet() {
            return this.valueMap.entrySet();
        }

        @Override
        public String toString() {
            StringWriter stringWriter = new StringWriter();
            JsonWriterImpl jsonWriterImpl = new JsonWriterImpl(stringWriter, this.bufferPool);
            jsonWriterImpl.write(this);
            jsonWriterImpl.close();
            return stringWriter.toString();
        }
    }
}

