/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.preferences.CollectionProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.server.OverpassServerPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.OverpassDownloadReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OverpassTurboQueryWizard;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.Utils;

public class OverpassDownloadAction
extends JosmAction {
    public OverpassDownloadAction() {
        super(I18n.tr("Download from Overpass API ...", new Object[0]), "download-overpass", I18n.tr("Download map data from Overpass API server.", new Object[0]), Shortcut.registerShortcut("file:download-overpass", I18n.tr("File: {0}", I18n.tr("Download from Overpass API ...", new Object[0])), 40, 5007), true, "overpassdownload/download", true);
        this.putValue("help", HelpUtil.ht("/Action/OverpassDownload"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        OverpassDownloadDialog overpassDownloadDialog = OverpassDownloadDialog.getInstance();
        overpassDownloadDialog.restoreSettings();
        overpassDownloadDialog.setVisible(true);
        if (!overpassDownloadDialog.isCanceled()) {
            overpassDownloadDialog.rememberSettings();
            Bounds bounds = overpassDownloadDialog.getSelectedDownloadArea();
            DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
            Future<?> future = downloadOsmTask.download(new OverpassDownloadReader(bounds, OverpassServerPreference.getOverpassServer(), overpassDownloadDialog.getOverpassQuery()), overpassDownloadDialog.isNewLayerRequired(), bounds, null);
            Main.worker.submit(new PostDownloadHandler(downloadOsmTask, future));
        }
    }

    static class OverpassQueryHistoryItem
    extends JMenuItem
    implements ActionListener {
        final String query;
        final OverpassDownloadDialog dialog;

        OverpassQueryHistoryItem(String string, OverpassDownloadDialog overpassDownloadDialog) {
            this.query = string;
            this.dialog = overpassDownloadDialog;
            this.setText("<html><pre style='width:300px;'>" + Utils.escapeReservedCharactersHTML(Utils.restrictStringLines(string, 7)));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.dialog.setOverpassQuery(this.query);
        }
    }

    static class OverpassQueryHistoryPopup
    extends JPopupMenu {
        static final CollectionProperty OVERPASS_QUERY_HISTORY = new CollectionProperty("download.overpass.query", (Collection<String>)new ArrayList<String>());
        static final IntegerProperty OVERPASS_QUERY_HISTORY_SIZE = new IntegerProperty("download.overpass.query.size", 12);

        OverpassQueryHistoryPopup(OverpassDownloadDialog overpassDownloadDialog) {
            Object object = OVERPASS_QUERY_HISTORY.get();
            this.setLayout(new GridLayout((int)Math.ceil((double)object.size() / 2.0), 2));
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.add(new OverpassQueryHistoryItem(string, overpassDownloadDialog));
            }
        }

        static void show(JComponent jComponent, OverpassDownloadDialog overpassDownloadDialog) {
            OverpassQueryHistoryPopup overpassQueryHistoryPopup = new OverpassQueryHistoryPopup(overpassDownloadDialog);
            Rectangle rectangle = jComponent.getBounds();
            overpassQueryHistoryPopup.show(jComponent.getParent(), rectangle.x + rectangle.width - (int)overpassQueryHistoryPopup.getPreferredSize().getWidth(), rectangle.y + rectangle.height);
        }

        static void addToHistory(String string) {
            LinkedList<String> linkedList = new LinkedList<String>((Collection<String>)OVERPASS_QUERY_HISTORY.get());
            if (!linkedList.contains(string)) {
                linkedList.add(string);
            }
            while (linkedList.size() > OVERPASS_QUERY_HISTORY_SIZE.get()) {
                linkedList.removeFirst();
            }
            OVERPASS_QUERY_HISTORY.put((Collection<String>)linkedList);
        }
    }

    private static final class OverpassDownloadDialog
    extends DownloadDialog {
        private HistoryComboBox overpassWizard;
        private JosmTextArea overpassQuery;
        private static OverpassDownloadDialog instance;
        private static final CollectionProperty OVERPASS_WIZARD_HISTORY;

        private OverpassDownloadDialog(Component component) {
            super(component, HelpUtil.ht("/Action/OverpassDownload"));
            this.cbDownloadOsmData.setEnabled(false);
            this.cbDownloadOsmData.setSelected(false);
            this.cbDownloadGpxData.setVisible(false);
            this.cbDownloadNotes.setVisible(false);
            this.cbStartup.setVisible(false);
        }

        public static OverpassDownloadDialog getInstance() {
            if (instance == null) {
                instance = new OverpassDownloadDialog(Main.parent);
            }
            return instance;
        }

        @Override
        protected void buildMainPanelAboveDownloadSelections(JPanel jPanel) {
            DisableActionsFocusListener disableActionsFocusListener = new DisableActionsFocusListener(this.slippyMapChooser.getNavigationComponentActionMap());
            jPanel.add((Component)new JLabel(), GBC.eol());
            String string = I18n.tr("Builds an Overpass query using the Overpass Turbo query wizard", new Object[0]);
            this.overpassWizard = new HistoryComboBox();
            this.overpassWizard.setToolTipText(string);
            this.overpassWizard.getEditorComponent().addFocusListener(disableActionsFocusListener);
            JButton jButton = new JButton(I18n.tr("Build query", new Object[0]));
            jButton.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = OverpassDownloadDialog.this.overpassWizard.getText();
                    try {
                        OverpassDownloadDialog.this.overpassQuery.setText(OverpassTurboQueryWizard.getInstance().constructQuery(string));
                    }
                    catch (UncheckedParseException uncheckedParseException) {
                        Main.error(uncheckedParseException);
                        HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>The Overpass wizard could not parse the following query:" + Utils.joinAsHtmlUnorderedList(Collections.singleton(string)), new Object[0]), I18n.tr("Parse error", new Object[0]), 0, null);
                    }
                }
            });
            jButton.setToolTipText(string);
            jPanel.add((Component)jButton, GBC.std().insets(5, 5, 5, 5));
            jPanel.add((Component)this.overpassWizard, GBC.eol().fill(2));
            this.overpassQuery = new JosmTextArea("", 8, 80);
            this.overpassQuery.setFont(GuiHelper.getMonospacedFont(this.overpassQuery));
            this.overpassQuery.addFocusListener(disableActionsFocusListener);
            JScrollPane jScrollPane = new JScrollPane(this.overpassQuery);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            final BasicArrowButton basicArrowButton = new BasicArrowButton(5);
            basicArrowButton.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OverpassQueryHistoryPopup.show(basicArrowButton, OverpassDownloadDialog.this);
                }
            });
            jPanel2.add((Component)jScrollPane, "Center");
            jPanel2.add((Component)basicArrowButton, "East");
            jPanel.add((Component)new JLabel(I18n.tr("Overpass query: ", new Object[0])), GBC.std().insets(5, 5, 5, 5));
            GBC gBC = GBC.eol().fill(2);
            gBC.ipady = 200;
            jPanel.add((Component)jPanel2, gBC);
        }

        public String getOverpassQuery() {
            return this.overpassQuery.getText();
        }

        public void setOverpassQuery(String string) {
            this.overpassQuery.setText(string);
        }

        @Override
        public void restoreSettings() {
            super.restoreSettings();
            this.overpassWizard.setPossibleItems((Collection<String>)OVERPASS_WIZARD_HISTORY.get());
        }

        @Override
        public void rememberSettings() {
            super.rememberSettings();
            this.overpassWizard.addCurrentItemToHistory();
            OVERPASS_WIZARD_HISTORY.put((Collection<String>)this.overpassWizard.getHistory());
            OverpassQueryHistoryPopup.addToHistory(this.getOverpassQuery());
        }

        static {
            OVERPASS_WIZARD_HISTORY = new CollectionProperty("download.overpass.wizard", (Collection<String>)new ArrayList<String>());
        }
    }

    private static final class DisableActionsFocusListener
    implements FocusListener {
        private final ActionMap actionMap;

        private DisableActionsFocusListener(ActionMap actionMap) {
            this.actionMap = actionMap;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.enableActions(false);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.enableActions(true);
        }

        private void enableActions(boolean bl) {
            Object[] objectArray = this.actionMap.allKeys();
            if (objectArray != null) {
                for (Object object : objectArray) {
                    Action action = this.actionMap.get(object);
                    if (action == null) continue;
                    action.setEnabled(bl);
                }
            }
        }
    }
}

