/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.PurgeCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class PurgeAction
extends JosmAction {
    protected transient OsmDataLayer layer;
    protected JCheckBox cbClearUndoRedo;
    protected transient Set<OsmPrimitive> toPurge;
    protected transient Set<OsmPrimitive> toPurgeChecked;
    protected transient Set<OsmPrimitive> makeIncomplete;
    protected transient List<OsmPrimitive> toPurgeAdditionally;

    public PurgeAction() {
        super(I18n.tr("Purge...", new Object[0]), "purge", I18n.tr("Forget objects but do not delete them on server when uploading.", new Object[0]), Shortcut.registerShortcut("system:purge", I18n.tr("Edit: {0}", I18n.tr("Purge", new Object[0])), 80, 5009), true);
        this.putValue("help", HelpUtil.ht("/Action/Purge"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        HashSet<OsmPrimitive> hashSet;
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = this.getLayerManager().getEditDataSet().getAllSelected();
        this.layer = Main.getLayerManager().getEditLayer();
        this.toPurge = new HashSet<OsmPrimitive>(collection);
        this.toPurgeAdditionally = new ArrayList<OsmPrimitive>();
        this.toPurgeChecked = new HashSet<OsmPrimitive>();
        HashSet<OsmPrimitive> hashSet2 = new HashSet<OsmPrimitive>();
        while (!this.toPurge.isEmpty()) {
            for (OsmPrimitive object : this.toPurge) {
                for (OsmPrimitive osmPrimitive : object.getReferrers()) {
                    if (this.toPurge.contains(osmPrimitive) || this.toPurgeChecked.contains(osmPrimitive) || hashSet2.contains(osmPrimitive) || !(osmPrimitive instanceof Way) && (!(osmPrimitive instanceof Relation) || !object.isNew())) continue;
                    this.toPurgeAdditionally.add(osmPrimitive);
                    hashSet2.add(osmPrimitive);
                }
                this.toPurgeChecked.add(object);
            }
            this.toPurge = hashSet2;
            hashSet2 = new HashSet();
        }
        this.makeIncomplete = new HashSet<OsmPrimitive>();
        block3: for (OsmPrimitive osmPrimitive : this.toPurgeChecked) {
            if (osmPrimitive.isNew()) continue;
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                if (!(osmPrimitive2 instanceof Relation) || this.toPurgeChecked.contains(osmPrimitive2)) continue;
                this.makeIncomplete.add(osmPrimitive);
                continue block3;
            }
        }
        if (Main.pref.getBoolean("purge.add_untagged_waynodes", true)) {
            hashSet = new HashSet();
            for (OsmPrimitive osmPrimitive : this.toPurgeChecked) {
                if (!(osmPrimitive instanceof Way)) continue;
                Way way = (Way)osmPrimitive;
                block6: for (Node node : way.getNodes()) {
                    if (node.isTagged() || this.toPurgeChecked.contains(node)) continue;
                    for (OsmPrimitive osmPrimitive3 : node.getReferrers()) {
                        if (osmPrimitive3 == way || this.toPurgeChecked.contains(osmPrimitive3)) continue;
                        continue block6;
                    }
                    hashSet.add(node);
                }
            }
            this.toPurgeChecked.addAll(hashSet);
            this.toPurgeAdditionally.addAll(hashSet);
        }
        if (Main.pref.getBoolean("purge.add_relations_with_only_incomplete_members", true)) {
            void var6_25;
            hashSet = new HashSet<OsmPrimitive>();
            for (OsmPrimitive osmPrimitive : this.toPurgeChecked) {
                for (OsmPrimitive osmPrimitive4 : osmPrimitive.getReferrers()) {
                    if (!(osmPrimitive4 instanceof Relation) || this.toPurgeChecked.contains(osmPrimitive4) || !PurgeAction.hasOnlyIncompleteMembers((Relation)osmPrimitive4, this.toPurgeChecked, hashSet)) continue;
                    hashSet.add((Relation)osmPrimitive4);
                }
            }
            ArrayList<Relation> arrayList = new ArrayList<Relation>(hashSet);
            boolean bl2 = false;
            while (var6_25 < arrayList.size()) {
                for (OsmPrimitive osmPrimitive : ((Relation)arrayList.get((int)var6_25)).getReferrers()) {
                    if (this.toPurgeChecked.contains(osmPrimitive) || !PurgeAction.hasOnlyIncompleteMembers((Relation)osmPrimitive, this.toPurgeChecked, arrayList)) continue;
                    arrayList.add((Relation)osmPrimitive);
                }
                ++var6_25;
            }
            hashSet = new HashSet(arrayList);
            this.toPurgeChecked.addAll(hashSet);
            this.toPurgeAdditionally.addAll(hashSet);
        }
        boolean bl3 = false;
        for (OsmPrimitive osmPrimitive : this.toPurgeChecked) {
            if (!osmPrimitive.isModified()) continue;
            bl3 = true;
            break;
        }
        boolean bl4 = false;
        if (!GraphicsEnvironment.isHeadless()) {
            boolean bl5 = ConditionalOptionPaneUtil.showConfirmationDialog("purge", Main.parent, this.buildPanel(bl3), I18n.tr("Confirm Purging", new Object[0]), 2, -1, 0);
            if (!bl5) {
                return;
            }
            bl = this.cbClearUndoRedo.isSelected();
            Main.pref.put("purge.clear_undo_redo", bl);
        }
        Main.main.undoRedo.add(new PurgeCommand(Main.getLayerManager().getEditLayer(), this.toPurgeChecked, this.makeIncomplete));
        if (bl) {
            Main.main.undoRedo.clean();
            this.getLayerManager().getEditDataSet().clearSelectionHistory();
        }
    }

    private JPanel buildPanel(boolean bl) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add(Box.createRigidArea(new Dimension(400, 0)), GBC.eol().fill(2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel("<html>" + I18n.tr("This operation makes JOSM forget the selected objects.<br> They will be removed from the layer, but <i>not</i> deleted<br> on the server when uploading.", new Object[0]) + "</html>", ImageProvider.get("purge"), 2), GBC.eol().fill(2));
        if (!this.toPurgeAdditionally.isEmpty()) {
            jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            jPanel.add((Component)new JLabel("<html>" + I18n.tr("The following dependent objects will be purged<br> in addition to the selected objects:", new Object[0]) + "</html>", ImageProvider.get("warning-small"), 2), GBC.eol().fill(2));
            Collections.sort(this.toPurgeAdditionally, new Comparator<OsmPrimitive>(){

                @Override
                public int compare(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
                    int n = osmPrimitive2.getType().compareTo(osmPrimitive.getType());
                    if (n != 0) {
                        return n;
                    }
                    return Long.compare(osmPrimitive.getUniqueId(), osmPrimitive2.getUniqueId());
                }
            });
            JList<OsmPrimitive> jList = new JList<OsmPrimitive>(this.toPurgeAdditionally.toArray(new OsmPrimitive[this.toPurgeAdditionally.size()]));
            jList.setCellRenderer(new OsmPrimitivRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<? extends OsmPrimitive> jList, OsmPrimitive osmPrimitive, int n, boolean bl, boolean bl2) {
                    return super.getListCellRendererComponent(jList, osmPrimitive, n, true, false);
                }
            });
            JScrollPane jScrollPane = new JScrollPane(jList);
            jScrollPane.setPreferredSize(new Dimension(250, 300));
            jScrollPane.setMinimumSize(new Dimension(250, 300));
            jPanel.add((Component)jScrollPane, GBC.std().fill(1).weight(1.0, 1.0));
            JButton jButton = new JButton(new AbstractAction(){
                {
                    this.putValue("ShortDescription", I18n.tr("Add to selection", new Object[0]));
                    this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PurgeAction.this.layer.data.addSelected(PurgeAction.this.toPurgeAdditionally);
                }
            });
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jPanel.add((Component)jButton, GBC.eol().anchor(16).weight(0.0, 1.0).insets(2, 0, 0, 3));
        }
        if (bl) {
            jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            jPanel.add((Component)new JLabel("<html>" + I18n.tr("Some of the objects are modified.<br> Proceed, if these changes should be discarded.</html>", new Object[0]), ImageProvider.get("warning-small"), 2), GBC.eol().fill(2));
        }
        this.cbClearUndoRedo = new JCheckBox(I18n.tr("Clear Undo/Redo buffer", new Object[0]));
        this.cbClearUndoRedo.setSelected(Main.pref.getBoolean("purge.clear_undo_redo", false));
        jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        jPanel.add((Component)this.cbClearUndoRedo, GBC.eol());
        return jPanel;
    }

    @Override
    protected void updateEnabledState() {
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (dataSet == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(!dataSet.selectionEmpty());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private static boolean hasOnlyIncompleteMembers(Relation relation, Collection<OsmPrimitive> collection, Collection<? extends OsmPrimitive> collection2) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.getMember().isIncomplete() || collection.contains(relationMember.getMember()) || collection2.contains(relationMember.getMember())) continue;
            return false;
        }
        return true;
    }
}

