/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.routines;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.validation.routines.AbstractValidator;
import org.openstreetmap.josm.data.validation.routines.DomainValidator;
import org.openstreetmap.josm.data.validation.routines.InetAddressValidator;
import org.openstreetmap.josm.data.validation.routines.RegexValidator;
import org.openstreetmap.josm.tools.I18n;

public class UrlValidator
extends AbstractValidator {
    public static final long ALLOW_ALL_SCHEMES = 1L;
    public static final long ALLOW_2_SLASHES = 2L;
    public static final long NO_FRAGMENTS = 4L;
    public static final long ALLOW_LOCAL_URLS = 8L;
    private static final String URL_REGEX = "^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?";
    private static final Pattern URL_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final int PARSE_URL_SCHEME = 2;
    private static final int PARSE_URL_AUTHORITY = 4;
    private static final int PARSE_URL_PATH = 5;
    private static final int PARSE_URL_QUERY = 7;
    private static final int PARSE_URL_FRAGMENT = 9;
    private static final String SCHEME_REGEX = "^\\p{Alpha}[\\p{Alnum}\\+\\-\\.]*";
    private static final Pattern SCHEME_PATTERN = Pattern.compile("^\\p{Alpha}[\\p{Alnum}\\+\\-\\.]*");
    private static final String AUTHORITY_CHARS_REGEX = "\\p{Alnum}\\-\\.";
    private static final String IPV6_REGEX = "[0-9a-fA-F:]+";
    private static final String USERINFO_CHARS_REGEX = "[a-zA-Z0-9%-._~!$&'()*+,;=]";
    private static final String USERINFO_FIELD_REGEX = "[a-zA-Z0-9%-._~!$&'()*+,;=]+:[a-zA-Z0-9%-._~!$&'()*+,;=]*@";
    private static final String AUTHORITY_REGEX = "(?:\\[([0-9a-fA-F:]+)\\]|(?:(?:[a-zA-Z0-9%-._~!$&'()*+,;=]+:[a-zA-Z0-9%-._~!$&'()*+,;=]*@)?([\\p{Alnum}\\-\\.]*)))(:\\d*)?(.*)?";
    private static final Pattern AUTHORITY_PATTERN = Pattern.compile("(?:\\[([0-9a-fA-F:]+)\\]|(?:(?:[a-zA-Z0-9%-._~!$&'()*+,;=]+:[a-zA-Z0-9%-._~!$&'()*+,;=]*@)?([\\p{Alnum}\\-\\.]*)))(:\\d*)?(.*)?");
    private static final int PARSE_AUTHORITY_IPV6 = 1;
    private static final int PARSE_AUTHORITY_HOST_IP = 2;
    private static final int PARSE_AUTHORITY_EXTRA = 4;
    private static final String PATH_REGEX = "^(/[-\\w:@&?=+,.!/~*'%$_;\\(\\)]*)?$";
    private static final Pattern PATH_PATTERN = Pattern.compile("^(/[-\\w:@&?=+,.!/~*'%$_;\\(\\)]*)?$");
    private static final String QUERY_REGEX = "^(.*)$";
    private static final Pattern QUERY_PATTERN = Pattern.compile("^(.*)$");
    private final long options;
    private final Set<String> allowedSchemes;
    private final RegexValidator authorityValidator;
    private static final String[] DEFAULT_SCHEMES = new String[]{"http", "https", "ftp"};
    private static final UrlValidator DEFAULT_URL_VALIDATOR = new UrlValidator();

    public static UrlValidator getInstance() {
        return DEFAULT_URL_VALIDATOR;
    }

    public UrlValidator() {
        this(null);
    }

    public UrlValidator(String[] stringArray) {
        this(stringArray, 0L);
    }

    public UrlValidator(long l) {
        this(null, null, l);
    }

    public UrlValidator(String[] stringArray, long l) {
        this(stringArray, null, l);
    }

    public UrlValidator(RegexValidator regexValidator, long l) {
        this(null, regexValidator, l);
    }

    public UrlValidator(String[] stringArray, RegexValidator regexValidator, long l) {
        this.options = l;
        if (this.isOn(1L)) {
            this.allowedSchemes = Collections.emptySet();
        } else {
            if (stringArray == null) {
                stringArray = DEFAULT_SCHEMES;
            }
            this.allowedSchemes = new HashSet<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                this.allowedSchemes.add(stringArray[i].toLowerCase(Locale.ENGLISH));
            }
        }
        this.authorityValidator = regexValidator;
    }

    @Override
    public boolean isValid(String string) {
        String string2;
        if (string == null) {
            return false;
        }
        Matcher matcher = URL_PATTERN.matcher(string);
        if (!matcher.matches()) {
            this.setErrorMessage(I18n.tr("URL is invalid", new Object[0]));
            return false;
        }
        String string3 = matcher.group(2);
        if (!this.isValidScheme(string3)) {
            this.setErrorMessage(I18n.tr("URL contains an invalid protocol: {0}", string3));
            return false;
        }
        String string4 = matcher.group(4);
        if ("file".equals(string3)) {
            if (!"".equals(string4) && string4.contains(":")) {
                this.setErrorMessage(I18n.tr("URL contains an invalid authority: {0}", string4));
                return false;
            }
        } else if (!this.isValidAuthority(string4)) {
            this.setErrorMessage(I18n.tr("URL contains an invalid authority: {0}", string4));
            return false;
        }
        if (!this.isValidPath(string2 = matcher.group(5))) {
            this.setErrorMessage(I18n.tr("URL contains an invalid path: {0}", string2));
            return false;
        }
        String string5 = matcher.group(7);
        if (!this.isValidQuery(string5)) {
            this.setErrorMessage(I18n.tr("URL contains an invalid query: {0}", string5));
            return false;
        }
        String string6 = matcher.group(9);
        if (!this.isValidFragment(string6)) {
            this.setErrorMessage(I18n.tr("URL contains an invalid fragment: {0}", string6));
            return false;
        }
        return true;
    }

    @Override
    public String getValidatorName() {
        return I18n.tr("URL validator", new Object[0]);
    }

    protected boolean isValidScheme(String string) {
        if (string == null) {
            return false;
        }
        if (!SCHEME_PATTERN.matcher(string).matches()) {
            return false;
        }
        return !this.isOff(1L) || this.allowedSchemes.contains(string.toLowerCase(Locale.ENGLISH));
    }

    protected boolean isValidAuthority(String string) {
        Object object;
        if (string == null) {
            return false;
        }
        if (this.authorityValidator != null && this.authorityValidator.isValid(string)) {
            return true;
        }
        String string2 = DomainValidator.unicodeToASCII(string);
        Matcher matcher = AUTHORITY_PATTERN.matcher(string2);
        if (!matcher.matches()) {
            return false;
        }
        String string3 = matcher.group(1);
        if (string3 != null) {
            object = InetAddressValidator.getInstance();
            if (!((InetAddressValidator)object).isValidInet6Address(string3)) {
                return false;
            }
        } else {
            InetAddressValidator inetAddressValidator;
            object = matcher.group(2);
            DomainValidator domainValidator = DomainValidator.getInstance(this.isOn(8L));
            if (!domainValidator.isValid((String)object) && !(inetAddressValidator = InetAddressValidator.getInstance()).isValidInet4Address((String)object)) {
                return false;
            }
        }
        return (object = matcher.group(4)) == null || ((String)object).trim().isEmpty();
    }

    protected boolean isValidPath(String string) {
        if (string == null) {
            return false;
        }
        if (!PATH_PATTERN.matcher(string).matches()) {
            return false;
        }
        try {
            URI uRI = new URI(null, null, string, null);
            String string2 = uRI.normalize().getPath();
            if (string2.startsWith("/../") || "/..".equals(string2)) {
                return false;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Main.trace(uRISyntaxException);
            return false;
        }
        int n = this.countToken("//", string);
        return !this.isOff(2L) || n <= 0;
    }

    protected boolean isValidQuery(String string) {
        if (string == null) {
            return true;
        }
        return QUERY_PATTERN.matcher(string).matches();
    }

    protected boolean isValidFragment(String string) {
        if (string == null) {
            return true;
        }
        return this.isOff(4L);
    }

    protected int countToken(String string, String string2) {
        int n = 0;
        int n2 = 0;
        while (n != -1) {
            if ((n = string2.indexOf(string, n)) <= -1) continue;
            ++n;
            ++n2;
        }
        return n2;
    }

    private boolean isOn(long l) {
        return (this.options & l) > 0L;
    }

    private boolean isOff(long l) {
        return (this.options & l) == 0L;
    }
}

