/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTable;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

abstract class AddFromSelectionAction
extends AbstractRelationEditorAction {
    protected final SelectionTable selectionTable;
    protected final SelectionTableModel selectionTableModel;

    protected AddFromSelectionAction(MemberTable memberTable, MemberTableModel memberTableModel, SelectionTable selectionTable, SelectionTableModel selectionTableModel, String string, OsmDataLayer osmDataLayer, IRelationEditor iRelationEditor) {
        super(memberTable, memberTableModel, string, osmDataLayer, iRelationEditor);
        this.selectionTable = selectionTable;
        this.selectionTableModel = selectionTableModel;
    }

    protected boolean isPotentialDuplicate(OsmPrimitive osmPrimitive) {
        return this.memberTableModel.hasMembersReferringTo(Collections.singleton(osmPrimitive));
    }

    protected List<OsmPrimitive> filterConfirmedPrimitives(List<OsmPrimitive> list) throws GenericRelationEditor.AddAbortException {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        ConditionalOptionPaneUtil.startBulkOperation("add_primitive_to_relation");
        for (OsmPrimitive osmPrimitive : list) {
            if (osmPrimitive instanceof Relation && this.editor.getRelation() != null && this.editor.getRelation().equals(osmPrimitive)) {
                GenericRelationEditor.warnOfCircularReferences(osmPrimitive);
                continue;
            }
            if (this.isPotentialDuplicate(osmPrimitive)) {
                if (!GenericRelationEditor.confirmAddingPrimitive(osmPrimitive)) continue;
                arrayList.add(osmPrimitive);
                continue;
            }
            arrayList.add(osmPrimitive);
        }
        ConditionalOptionPaneUtil.endBulkOperation("add_primitive_to_relation");
        return arrayList;
    }
}

