/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadOpenChangesetsTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private OsmServerChangesetReader reader;
    private List<Changeset> changesets;
    private Exception lastException;
    private final Component parent;

    public DownloadOpenChangesetsTask(Component component) {
        super(component, I18n.tr("Downloading open changesets ...", new Object[0]), false);
        this.parent = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        DownloadOpenChangesetsTask downloadOpenChangesetsTask = this;
        synchronized (downloadOpenChangesetsTask) {
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (JosmUserIdentityManager.getInstance().isAnonymous()) {
            JOptionPane.showMessageDialog(GuiHelper.getFrameForComponent(this.parent), "<html>" + I18n.tr("Could not retrieve the list of your open changesets because<br>JOSM does not know your identity.<br>You have either chosen to work anonymously or you are not entitled<br>to know the identity of the user on whose behalf you are working.", new Object[0]) + "</html>", I18n.tr("Missing user identity", new Object[0]), 0);
            return;
        }
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        if (this.changesets.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no open changesets", new Object[0]), I18n.tr("No open changesets", new Object[0]), 1);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChangesetCache.getInstance().update(DownloadOpenChangesetsTask.this.changesets);
            }
        });
    }

    protected void refreshUserIdentity() {
        JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
        try {
            OsmServerUserInfoReader osmServerUserInfoReader = new OsmServerUserInfoReader();
            UserInfo userInfo = osmServerUserInfoReader.fetchUserInfo(this.getProgressMonitor().createSubTaskMonitor(1, false));
            josmUserIdentityManager.setFullyIdentified(userInfo.getDisplayName(), userInfo);
        }
        catch (OsmTransferException osmTransferException) {
            if (josmUserIdentityManager.isFullyIdentified()) {
                josmUserIdentityManager.setPartiallyIdentified(josmUserIdentityManager.getUserName());
            }
            Main.warn(I18n.tr("Failed to retrieve user infos for the current JOSM user. Exception was: {0}", osmTransferException.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
            if (josmUserIdentityManager.isAnonymous()) {
                this.refreshUserIdentity();
            } else if (!josmUserIdentityManager.isFullyIdentified() && josmUserIdentityManager.isPartiallyIdentified()) {
                this.refreshUserIdentity();
            }
            if (this.canceled) {
                return;
            }
            Object object = this;
            synchronized (object) {
                this.reader = new OsmServerChangesetReader();
            }
            object = new ChangesetQuery().beingOpen(true);
            if (josmUserIdentityManager.isAnonymous()) {
                return;
            }
            object = josmUserIdentityManager.isFullyIdentified() ? ((ChangesetQuery)object).forUser(josmUserIdentityManager.getUserId()) : ((ChangesetQuery)object).forUser(josmUserIdentityManager.getUserName());
            this.changesets = this.reader.queryChangesets((ChangesetQuery)object, this.getProgressMonitor().createSubTaskMonitor(1, false));
        }
        catch (OsmTransferException osmTransferException) {
            if (this.canceled) {
                return;
            }
            this.lastException = osmTransferException;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

