/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.gui.widgets.TextContextualPopupMenu;

public class JosmComboBox<E>
extends JComboBox<E> {
    public JosmComboBox() {
        this.init(null);
    }

    public JosmComboBox(E e) {
        this.init(e);
    }

    public JosmComboBox(ComboBoxModel<E> comboBoxModel) {
        super(comboBoxModel);
        ArrayList arrayList = new ArrayList(comboBoxModel.getSize());
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            arrayList.add(comboBoxModel.getElementAt(i));
        }
        this.init(this.findPrototypeDisplayValue(arrayList));
    }

    public JosmComboBox(E[] EArray) {
        super(EArray);
        this.init(this.findPrototypeDisplayValue(Arrays.asList(EArray)));
    }

    public JTextField getEditorComponent() {
        return (JTextField)this.getEditor().getEditorComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final E findPrototypeDisplayValue(Collection<E> collection) {
        E e = null;
        int n = -1;
        if (collection != null) {
            Object e2 = this.getPrototypeDisplayValue();
            JList<Object> jList = this.getList();
            try {
                int n2 = 0;
                for (E e3 : collection) {
                    Component component;
                    if (e3 != null && (component = this.getRenderer().getListCellRendererComponent(jList, e3, n2, true, true)) != null) {
                        Dimension dimension = component.getPreferredSize();
                        if (dimension.height > n) {
                            n = dimension.height;
                            e = e3;
                        }
                    }
                    ++n2;
                }
            }
            finally {
                this.setPrototypeDisplayValue(e2);
            }
        }
        return e;
    }

    protected final JList<Object> getList() {
        for (int i = 0; i < this.getUI().getAccessibleChildrenCount(this); ++i) {
            Accessible accessible = this.getUI().getAccessibleChild(this, i);
            if (!(accessible instanceof ComboPopup)) continue;
            return ((ComboPopup)((Object)accessible)).getList();
        }
        return null;
    }

    protected final void init(E e) {
        if (e != null) {
            this.setPrototypeDisplayValue(e);
            int n = GuiHelper.getScreenSize().height;
            int n2 = n / this.getPreferredSize().height / 2;
            JList<Object> jList = this.getList();
            if (jList != null) {
                int n3;
                if (!e.equals(jList.getPrototypeCellValue())) {
                    jList.setPrototypeCellValue(e);
                }
                if ((n3 = jList.getFixedCellHeight()) > 0) {
                    n2 = n / n3 / 2;
                }
            }
            this.setMaximumRowCount(Math.max(this.getMaximumRowCount(), n2));
        }
        ContextMenuHandler contextMenuHandler = new ContextMenuHandler();
        this.addPropertyChangeListener("editable", contextMenuHandler);
        this.addPropertyChangeListener("editor", contextMenuHandler);
    }

    public final void reinitialize(Collection<E> collection) {
        this.init(this.findPrototypeDisplayValue(collection));
    }

    protected class ContextMenuHandler
    extends MouseAdapter
    implements PropertyChangeListener {
        private JTextComponent component;
        private PopupMenuLauncher launcher;

        protected ContextMenuHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("editable".equals(propertyChangeEvent.getPropertyName())) {
                if (propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    this.enableMenu();
                } else {
                    this.disableMenu();
                }
            } else if ("editor".equals(propertyChangeEvent.getPropertyName())) {
                this.disableMenu();
                if (JosmComboBox.this.isEditable()) {
                    this.enableMenu();
                }
            }
        }

        private void enableMenu() {
            Component component;
            if (this.launcher == null && JosmComboBox.this.editor != null && (component = JosmComboBox.this.editor.getEditorComponent()) instanceof JTextComponent) {
                this.component = (JTextComponent)component;
                this.component.addMouseListener(this);
                this.launcher = TextContextualPopupMenu.enableMenuFor(this.component, true);
            }
        }

        private void disableMenu() {
            if (this.launcher != null) {
                TextContextualPopupMenu.disableMenuFor(this.component, this.launcher);
                this.launcher = null;
                this.component.removeMouseListener(this);
                this.component = null;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.processEvent(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.processEvent(mouseEvent);
        }

        private void processEvent(MouseEvent mouseEvent) {
            if (this.launcher != null && !mouseEvent.isPopupTrigger() && this.launcher.getMenu().isShowing()) {
                this.launcher.getMenu().setVisible(false);
            }
        }
    }
}

