/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.IOException;
import jnr.posix.FileStat;
import jnr.posix.util.Platform;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.runtime.Block;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;

public class RubyArgsFile
extends RubyObject {
    private static final ObjectAllocator ARGF_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyArgsFile(runtime, klass);
        }
    };

    public RubyArgsFile(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public static void initArgsFile(Ruby runtime) {
        RubyClass argfClass = runtime.defineClass("ARGFClass", runtime.getObject(), ARGF_ALLOCATOR);
        argfClass.includeModule(runtime.getEnumerable());
        argfClass.defineAnnotatedMethods(RubyArgsFile.class);
        IRubyObject argsFile = argfClass.newInstance(runtime.getCurrentContext(), new IRubyObject[]{null}, (Block)null);
        runtime.setArgsFile(argsFile);
        runtime.getGlobalVariables().defineReadonly("$<", new ArgsFileAccessor(runtime), GlobalVariable.Scope.GLOBAL);
        runtime.defineGlobalConstant("ARGF", argsFile);
        runtime.defineReadonlyVariable("$FILENAME", runtime.newString("-"), GlobalVariable.Scope.GLOBAL);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, rest=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        RubyArray argv2 = args2.length == 1 && args2[0] == null ? runtime.getObject().getConstant("ARGV").convertToArray() : runtime.newArray(args2);
        ArgsFileData data2 = new ArgsFileData(runtime, argv2);
        this.dataWrapStruct(data2);
        return this;
    }

    public static void setCurrentLineNumber(IRubyObject recv2, int newLineNumber) {
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        if (data2 != null) {
            data2.currentLineNumber = newLineNumber;
        }
    }

    @JRubyMethod(name={"argv"})
    public static IRubyObject argv(ThreadContext context, IRubyObject recv2) {
        return ArgsFileData.getDataFrom(recv2).argv;
    }

    @JRubyMethod(name={"fileno", "to_i"})
    public static IRubyObject fileno(ThreadContext context, IRubyObject recv2) {
        return ((RubyIO)RubyArgsFile.getData((ThreadContext)context, (IRubyObject)recv2, (String)"no stream").currentFile).fileno(context);
    }

    @JRubyMethod(name={"to_io"})
    public static IRubyObject to_io(ThreadContext context, IRubyObject recv2) {
        return RubyArgsFile.getData((ThreadContext)context, (IRubyObject)recv2, (String)"no stream").currentFile;
    }

    @JRubyMethod
    public static IRubyObject set_encoding(ThreadContext context, IRubyObject recv2, IRubyObject encoding2) {
        return ((RubyIO)RubyArgsFile.getData((ThreadContext)context, (IRubyObject)recv2, (String)"no stream to set encoding").currentFile).set_encoding(context, encoding2);
    }

    @JRubyMethod
    public static IRubyObject set_encoding(ThreadContext context, IRubyObject recv2, IRubyObject encoding2, IRubyObject internalEncoding) {
        return ((RubyIO)RubyArgsFile.getData((ThreadContext)context, (IRubyObject)recv2, (String)"no stream to set encoding").currentFile).set_encoding(context, encoding2, internalEncoding);
    }

    @JRubyMethod
    public static IRubyObject set_encoding(ThreadContext context, IRubyObject recv2, IRubyObject encoding2, IRubyObject internalEncoding, IRubyObject options2) {
        return ((RubyIO)RubyArgsFile.getData((ThreadContext)context, (IRubyObject)recv2, (String)"no stream to set encoding").currentFile).set_encoding(context, encoding2, internalEncoding, options2);
    }

    @JRubyMethod
    public static IRubyObject internal_encoding(ThreadContext context, IRubyObject recv2) {
        return ((RubyIO)RubyArgsFile.getData((ThreadContext)context, (IRubyObject)recv2, (String)"no stream to set encoding").currentFile).internal_encoding(context);
    }

    @JRubyMethod
    public static IRubyObject external_encoding(ThreadContext context, IRubyObject recv2) {
        return ((RubyIO)RubyArgsFile.getData((ThreadContext)context, (IRubyObject)recv2, (String)"no stream to set encoding").currentFile).external_encoding(context);
    }

    private static IRubyObject argf_getline(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        boolean retry = true;
        IRubyObject line = null;
        while (retry) {
            retry = false;
            if (!data2.next_argv(context)) {
                return context.nil;
            }
            line = data2.currentFile.callMethod(context, "gets", args2);
            if (!line.isNil() || data2.next_p == -1) continue;
            RubyArgsFile.argf_close(context, data2.currentFile);
            data2.next_p = 1;
            retry = true;
        }
        if (line != null && !line.isNil()) {
            context.runtime.setCurrentLine(data2.currentLineNumber);
        }
        return line;
    }

    @JRubyMethod(name={"gets"}, optional=1, writes={FrameField.LASTLINE})
    public static IRubyObject gets(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line = RubyArgsFile.argf_getline(context, recv2, args2);
        context.setLastLine(line);
        return line;
    }

    @JRubyMethod(name={"readline"}, optional=1)
    public static IRubyObject readline(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line = RubyArgsFile.gets(context, recv2, args2);
        if (line.isNil()) {
            throw context.runtime.newEOFError();
        }
        return line;
    }

    @JRubyMethod(optional=1)
    public static IRubyObject readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line;
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        Ruby runtime = context.runtime;
        if (!data2.next_argv(context)) {
            return runtime.newEmptyArray();
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            return data2.currentFile.callMethod(context, "readlines", args2);
        }
        RubyArray ary = runtime.newArray();
        while (!(line = RubyArgsFile.argf_getline(context, recv2, args2)).isNil()) {
            ary.append(line);
        }
        return ary;
    }

    @JRubyMethod(optional=1)
    public static IRubyObject to_a(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line;
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        Ruby runtime = context.runtime;
        if (!data2.next_argv(context)) {
            return runtime.newEmptyArray();
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            return data2.currentFile.callMethod(context, "to_a", args2);
        }
        RubyArray ary = runtime.newArray();
        while (!(line = RubyArgsFile.argf_getline(context, recv2, args2)).isNil()) {
            ary.append(line);
        }
        return ary;
    }

    public static IRubyObject each_byte(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject bt;
        while (!(bt = RubyArgsFile.getc(context, recv2)).isNil()) {
            block.yield(context, bt);
        }
        return recv2;
    }

    @JRubyMethod(optional=1)
    public static IRubyObject each_byte(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_byte(context, recv2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "each_byte");
    }

    @JRubyMethod(optional=1)
    public static IRubyObject bytes(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_byte(context, recv2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "bytes");
    }

    @JRubyMethod
    public static IRubyObject each_char(ThreadContext context, IRubyObject recv2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_charCommon(context, recv2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "each_char");
    }

    @JRubyMethod
    public static IRubyObject chars(ThreadContext context, IRubyObject recv2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_charCommon(context, recv2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "chars");
    }

    public static IRubyObject each_charCommon(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject ch;
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        Ruby runtime = context.runtime;
        while (!(ch = RubyArgsFile.getc(context, recv2)).isNil()) {
            boolean cont = true;
            while (cont) {
                cont = false;
                byte c = (byte)RubyNumeric.fix2int(ch);
                int n = runtime.getKCode().getEncoding().length(c);
                IRubyObject file2 = data2.currentFile;
                RubyString str = runtime.newString();
                str.setTaint(true);
                str.cat(c);
                while (--n > 0) {
                    ch = RubyArgsFile.getc(context, recv2);
                    if (ch.isNil()) {
                        block.yield(context, str);
                        return recv2;
                    }
                    if (data2.currentFile != file2) {
                        block.yield(context, str);
                        cont = true;
                        continue;
                    }
                    c = (byte)RubyNumeric.fix2int(ch);
                    str.cat(c);
                }
                block.yield(context, str);
            }
        }
        return recv2;
    }

    public static IRubyObject each_line(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject str;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, recv2, "each_line");
        }
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        if (!data2.next_argv(context)) {
            return context.runtime.getNil();
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            if (!data2.next_argv(context)) {
                return recv2;
            }
            data2.currentFile.callMethod(context, "each", NULL_ARRAY, block);
            data2.next_p = 1;
        }
        while (!(str = RubyArgsFile.argf_getline(context, recv2, args2)).isNil()) {
            block.yield(context, str);
        }
        return recv2;
    }

    @JRubyMethod(optional=1)
    public static IRubyObject lines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyArgsFile.each_line(context, recv2, args2, block);
    }

    @JRubyMethod(name={"each_line"}, optional=1)
    public static IRubyObject each_line19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_line(context, recv2, args2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "each_line", args2);
    }

    @JRubyMethod(name={"each"}, optional=1)
    public static IRubyObject each19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_line(context, recv2, args2, block) : RubyEnumerator.enumeratorize(context.runtime, recv2, "each", args2);
    }

    @JRubyMethod(name={"file"})
    public static IRubyObject file(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        data2.next_argv(context);
        return data2.currentFile;
    }

    @JRubyMethod(name={"skip"})
    public static IRubyObject skip(IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        if (data2.next_p != -1) {
            RubyArgsFile.argf_close(recv2.getRuntime().getCurrentContext(), data2.currentFile);
            data2.next_p = 1;
        }
        return recv2;
    }

    public static void argf_close(ThreadContext context, IRubyObject file2) {
        if (file2 instanceof RubyIO) {
            ((RubyIO)file2).rbIoClose(context.runtime);
        } else {
            file2.callMethod(context, "close");
        }
    }

    @JRubyMethod(name={"close"})
    public static IRubyObject close(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        data2.next_argv(context);
        RubyArgsFile.argf_close(context, data2.currentFile);
        if (data2.next_p != -1) {
            data2.next_p = 1;
        }
        data2.currentLineNumber = 0;
        return recv2;
    }

    @JRubyMethod(name={"closed?"})
    public static IRubyObject closed_p(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        data2.next_argv(context);
        return RubyBoolean.newBoolean(context.runtime, RubyArgsFile.isClosed(context, data2.currentFile));
    }

    private static boolean isClosed(ThreadContext context, IRubyObject currentFile) {
        if (!(currentFile instanceof RubyIO)) {
            return currentFile.callMethod(context, "closed?").isTrue();
        }
        return ((RubyIO)currentFile).closed_p(context).isTrue();
    }

    @JRubyMethod(name={"binmode"})
    public static IRubyObject binmode(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = RubyArgsFile.getData(context, recv2, "no stream");
        ((RubyIO)data2.currentFile).binmode();
        return recv2;
    }

    @JRubyMethod(name={"binmode?"})
    public static IRubyObject op_binmode(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = RubyArgsFile.getData(context, recv2, "no stream");
        return ((RubyIO)data2.currentFile).op_binmode(context);
    }

    @JRubyMethod(name={"lineno"})
    public static IRubyObject lineno(ThreadContext context, IRubyObject recv2) {
        return recv2.getRuntime().newFixnum(ArgsFileData.getDataFrom((IRubyObject)recv2).currentLineNumber);
    }

    @JRubyMethod(name={"lineno="})
    public static IRubyObject lineno_set(ThreadContext context, IRubyObject recv2, IRubyObject line) {
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        data2.currentLineNumber = RubyNumeric.fix2int(line);
        context.runtime.setCurrentLine(data2.currentLineNumber);
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"tell"}, alias={"pos"})
    public static IRubyObject tell(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        if (!data2.next_argv(context)) {
            throw context.runtime.newArgumentError("no stream to tell");
        }
        return ((RubyIO)data2.currentFile).pos(context);
    }

    @JRubyMethod(name={"rewind"})
    public static IRubyObject rewind(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = RubyArgsFile.getData(context, recv2, "no stream to rewind");
        RubyFixnum retVal = ((RubyIO)data2.currentFile).rewind(context);
        ((RubyIO)data2.currentFile).lineno_set(context, context.runtime.newFixnum(0));
        data2.minLineNumber = 0;
        data2.currentLineNumber = 0;
        return retVal;
    }

    @JRubyMethod(name={"eof"})
    public static IRubyObject eof(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        if (!data2.inited) {
            return context.runtime.getTrue();
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            return data2.currentFile.callMethod(context, "eof");
        }
        return ((RubyIO)data2.currentFile).eof_p(context);
    }

    @JRubyMethod(name={"eof?"})
    public static IRubyObject eof_p(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        if (!data2.inited) {
            return context.runtime.getTrue();
        }
        if (!(data2.currentFile instanceof RubyIO)) {
            return data2.currentFile.callMethod(context, "eof?");
        }
        return ((RubyIO)data2.currentFile).eof_p(context);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public static IRubyObject set_pos(ThreadContext context, IRubyObject recv2, IRubyObject offset2) {
        ArgsFileData data2 = RubyArgsFile.getData(context, recv2, "no stream to set position");
        return ((RubyIO)data2.currentFile).pos_set(context, offset2);
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1)
    public static IRubyObject seek(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        ArgsFileData data2 = RubyArgsFile.getData(context, recv2, "no stream to seek");
        return ((RubyIO)data2.currentFile).seek(context, args2);
    }

    @JRubyMethod(name={"readchar"})
    public static IRubyObject readchar(ThreadContext context, IRubyObject recv2) {
        IRubyObject c = RubyArgsFile.getc(context, recv2);
        if (c.isNil()) {
            throw context.runtime.newEOFError();
        }
        return c;
    }

    @JRubyMethod
    public static IRubyObject getbyte(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        while (data2.next_argv(context)) {
            IRubyObject bt = !(data2.currentFile instanceof RubyFile) ? data2.currentFile.callMethod(context, "getbyte") : ((RubyIO)data2.currentFile).getbyte(context);
            if (!bt.isNil()) {
                return bt;
            }
            data2.next_p = 1;
        }
        return context.runtime.getNil();
    }

    @JRubyMethod(required=1, optional=2)
    public static IRubyObject read_nonblock(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyArgsFile.getPartial(context, recv2, args2, true);
    }

    @JRubyMethod(required=1, optional=1)
    public static IRubyObject readpartial(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyArgsFile.getPartial(context, recv2, args2, false);
    }

    private static IRubyObject getPartial(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, boolean nonBlocking) {
        ArgsFileData data2;
        Ruby runtime = context.runtime;
        boolean noException = false;
        if (args2.length > 1) {
            IRubyObject opts = TypeConverter.checkHashType(runtime, args2[args2.length - 1]);
            if (!opts.isNil() && runtime.getFalse() == ((RubyHash)opts).op_aref(context, runtime.newSymbol("exception"))) {
                noException = true;
            }
            if (args2.length > 2 || opts.isNil()) {
                args2[1] = args2[1].convertToString();
            }
        }
        if (!(data2 = ArgsFileData.getDataFrom(recv2)).next_argv(context)) {
            return RubyIO.nonblockEOF(runtime, noException);
        }
        IRubyObject res = ((RubyIO)data2.currentFile).getPartial(context, args2, nonBlocking, noException);
        if (res.isNil()) {
            if (data2.next_p == -1) {
                return RubyIO.nonblockEOF(runtime, noException);
            }
            RubyArgsFile.argf_close(context, data2.currentFile);
            data2.next_p = 1;
            if (data2.argv.size() == 0) {
                return RubyIO.nonblockEOF(runtime, noException);
            }
            if (args2.length > 1 && args2[1] instanceof RubyString) {
                return args2[1];
            }
            return RubyString.newEmptyString(runtime);
        }
        return res;
    }

    @JRubyMethod
    public static IRubyObject readbyte(ThreadContext context, IRubyObject recv2) {
        IRubyObject c = RubyArgsFile.getbyte(context, recv2);
        if (c.isNil()) {
            throw context.runtime.newEOFError();
        }
        return c;
    }

    @JRubyMethod(name={"getc"})
    public static IRubyObject getc(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        while (data2.next_argv(context)) {
            IRubyObject bt = !(data2.currentFile instanceof RubyFile) ? data2.currentFile.callMethod(context, "getc") : ((RubyIO)data2.currentFile).getc();
            if (!bt.isNil()) {
                return bt;
            }
            data2.next_p = 1;
        }
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"read"}, optional=2)
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject str;
        IRubyObject length2;
        Ruby runtime = context.runtime;
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        long len = 0L;
        if (args2.length > 0) {
            length2 = args2[0];
            str = args2.length > 1 ? args2[1] : runtime.getNil();
        } else {
            length2 = runtime.getNil();
            str = runtime.getNil();
        }
        if (!length2.isNil()) {
            len = RubyNumeric.num2long(length2);
        }
        if (!str.isNil()) {
            str = str.convertToString();
            ((RubyString)str).modify();
            ((RubyString)str).getByteList().length(0);
            args2[1] = runtime.getNil();
        }
        while (true) {
            if (!data2.next_argv(context)) {
                return str;
            }
            IRubyObject tmp = !(data2.currentFile instanceof RubyIO) ? data2.currentFile.callMethod(context, "read", args2) : ((RubyIO)data2.currentFile).read(args2);
            if (str.isNil()) {
                str = tmp;
            } else if (!tmp.isNil()) {
                ((RubyString)str).append(tmp);
            }
            if (tmp.isNil() || length2.isNil()) {
                if (data2.next_p == -1) break;
                RubyArgsFile.argf_close(context, data2.currentFile);
                data2.next_p = 1;
                continue;
            }
            if (args2.length < 1 || (long)((RubyString)str).getByteList().length() >= len) break;
            args2[0] = runtime.newFixnum(len -= (long)((RubyString)str).getByteList().length());
        }
        return str;
    }

    @JRubyMethod(name={"filename"}, alias={"path"})
    public static IRubyObject filename(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        data2.next_argv(context);
        return context.runtime.getGlobalVariables().get("$FILENAME");
    }

    @JRubyMethod(name={"to_s"}, alias={"inspect"})
    public static IRubyObject to_s(IRubyObject recv2) {
        return recv2.getRuntime().newString("ARGF");
    }

    private static ArgsFileData getData(ThreadContext context, IRubyObject recv2, String errorMessage) {
        ArgsFileData data2 = ArgsFileData.getDataFrom(recv2);
        if (!data2.next_argv(context)) {
            throw context.runtime.newArgumentError(errorMessage);
        }
        return data2;
    }

    static final class ArgsFileData {
        private final Ruby runtime;
        private final RubyArray argv;
        public IRubyObject currentFile;
        public int currentLineNumber;
        public int minLineNumber;
        private boolean inited = false;
        public int next_p = 0;

        public ArgsFileData(Ruby runtime, RubyArray argv2) {
            this.runtime = runtime;
            this.argv = argv2;
            this.currentFile = runtime.getNil();
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean next_argv(ThreadContext context) {
            if (!this.inited) {
                this.next_p = this.argv.getLength() > 0 ? 1 : -1;
                this.inited = true;
                this.currentLineNumber = 0;
            }
            IRubyObject $FILENAME = this.runtime.getGlobalVariables().get("$FILENAME");
            if (this.next_p != 1) {
                if (this.next_p != -1) return true;
                this.currentFile = this.runtime.getGlobalVariables().get("$stdin");
                if (ArgsFileData.filenameEqlDash((RubyString)$FILENAME)) return true;
                this.runtime.defineReadonlyVariable("$FILENAME", this.runtime.newString("-"), GlobalVariable.Scope.GLOBAL);
                return true;
            }
            this.next_p = 0;
            if (this.argv.getLength() <= 0) {
                this.next_p = 1;
                return false;
            }
            RubyString filename2 = this.argv.shift(context).convertToString();
            if (!filename2.op_equal(context, $FILENAME).isTrue()) {
                this.runtime.defineReadonlyVariable("$FILENAME", filename2, GlobalVariable.Scope.GLOBAL);
            }
            if (ArgsFileData.filenameEqlDash(filename2)) {
                this.currentFile = this.runtime.getGlobalVariables().get("$stdin");
                return true;
            }
            this.currentFile = RubyFile.open(context, this.runtime.getFile(), new IRubyObject[]{filename2}, Block.NULL_BLOCK);
            String extension = this.runtime.getInstanceConfig().getInPlaceBackupExtension();
            if (extension != null) {
                if (Platform.IS_WINDOWS) {
                    this.inplaceEditWindows(context, filename2.asJavaString(), extension);
                } else {
                    this.inplaceEdit(context, filename2.asJavaString(), extension);
                }
            }
            this.minLineNumber = this.currentLineNumber;
            this.currentFile.callMethod(context, "lineno=", context.runtime.newFixnum(this.currentLineNumber));
            return true;
        }

        private static boolean filenameEqlDash(RubyString filename2) {
            ByteList filenameBytes = filename2.getByteList();
            return filenameBytes.length() == 1 && filenameBytes.get(0) == 45;
        }

        public static ArgsFileData getDataFrom(IRubyObject recv2) {
            ArgsFileData data2 = (ArgsFileData)recv2.dataGetStruct();
            if (data2 == null) {
                Ruby runtime = recv2.getRuntime();
                data2 = new ArgsFileData(runtime, runtime.newEmptyArray());
                recv2.dataWrapStruct(data2);
            }
            return data2;
        }

        private void createNewFile(File file2) {
            try {
                file2.createNewFile();
            }
            catch (IOException ex) {
                throw this.runtime.newIOErrorFromException(ex);
            }
        }

        private void inplaceEditWindows(ThreadContext context, String filename2, String extension) throws RaiseException {
            File file2 = new File(filename2);
            if (extension.length() <= 0) {
                throw this.runtime.newIOError("Windows doesn't support inplace editing without a backup");
            }
            String backup = filename2 + extension;
            File backupFile = new File(backup);
            ((RubyIO)this.currentFile).close();
            backupFile.delete();
            file2.renameTo(backupFile);
            this.currentFile = RubyFile.open(context, this.runtime.getFile(), new IRubyObject[]{this.runtime.newString(backup)}, Block.NULL_BLOCK);
            this.createNewFile(file2);
            this.runtime.getGlobalVariables().set("$stdout", RubyFile.open(context, this.runtime.getFile(), new IRubyObject[]{this.runtime.newString(filename2), this.runtime.newString("w")}, Block.NULL_BLOCK));
        }

        private void inplaceEdit(ThreadContext context, String filename2, String extension) throws RaiseException {
            File file2 = new File(filename2);
            FileStat stat2 = this.runtime.getPosix().stat(filename2);
            if (extension.length() > 0) {
                file2.renameTo(new File(filename2 + extension));
            } else {
                file2.delete();
            }
            this.createNewFile(file2);
            this.runtime.getPosix().chmod(filename2, stat2.mode());
            this.runtime.getPosix().chown(filename2, stat2.uid(), stat2.gid());
            this.runtime.getGlobalVariables().set("$stdout", (RubyIO)RubyFile.open(context, this.runtime.getFile(), new IRubyObject[]{this.runtime.newString(filename2), this.runtime.newString("w")}, Block.NULL_BLOCK));
        }
    }

    private static class ArgsFileAccessor
    implements IAccessor {
        private final Ruby runtime;

        ArgsFileAccessor(Ruby runtime) {
            this.runtime = runtime;
        }

        @Override
        public IRubyObject getValue() {
            return this.runtime.getArgsFile();
        }

        @Override
        public IRubyObject setValue(IRubyObject newValue) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

