/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;

public class ReaderInputStream
extends InputStream {
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    private final Reader reader;
    private byte[] bytes = null;
    private int totalBytes = 0;
    private int position = 0;
    private int markedIndex = -1;
    private int readlimit = 0;
    private boolean isOpen = true;
    private CharsetEncoder encoder;
    private final Object lock = new Object();

    public ReaderInputStream(Reader reader) {
        this(reader, null);
    }

    public ReaderInputStream(Reader reader, String encoding2) {
        this.reader = reader;
        if (encoding2 == null) {
            encoding2 = reader instanceof InputStreamReader ? ((InputStreamReader)reader).getEncoding() : Charset.defaultCharset().name();
        } else if (!Charset.isSupported(encoding2)) {
            throw new IllegalArgumentException(encoding2 + " is not supported");
        }
        this.encoder = Charset.forName(encoding2).newEncoder();
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        try {
            this.fillByteBuffer(reader);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void fillByteBuffer(Reader reader) throws IOException {
        CharBuffer cbuf = CharBuffer.allocate(8192);
        ByteBuffer bbuf = ByteBuffer.allocate(8192);
        ArrayList<byte[]> list2 = new ArrayList<byte[]>();
        block0: while (true) {
            cbuf.clear();
            int size2 = reader.read(cbuf);
            if (size2 <= 0) break;
            cbuf.limit(cbuf.position());
            cbuf.rewind();
            boolean eof2 = false;
            while (true) {
                if (eof2) continue block0;
                CoderResult cr = this.encoder.encode(cbuf, bbuf, eof2);
                if (cr.isError()) {
                    cr.throwException();
                    continue;
                }
                if (cr.isUnderflow()) {
                    this.appendBytes(list2, bbuf);
                    eof2 = true;
                    continue;
                }
                if (!cr.isOverflow()) continue;
                this.appendBytes(list2, bbuf);
                bbuf.clear();
            }
            break;
        }
        this.getByteArray(list2);
    }

    private void appendBytes(List<byte[]> list2, ByteBuffer bb) {
        bb.flip();
        int length2 = bb.limit();
        this.totalBytes += length2;
        byte[] dst = new byte[length2];
        System.arraycopy(bb.array(), bb.position(), dst, 0, length2);
        list2.add(dst);
    }

    private void getByteArray(List<byte[]> list2) {
        this.bytes = new byte[this.totalBytes];
        int index2 = 0;
        for (byte[] bb : list2) {
            for (int i2 = 0; i2 < bb.length; ++i2) {
                this.bytes[index2++] = bb[i2];
            }
        }
    }

    private void confirmOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("This stream has been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.confirmOpen();
            if (this.bytes == null) {
                throw new IOException("This stream is not available.");
            }
            return this.totalBytes - this.position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.confirmOpen();
            this.isOpen = false;
            this.encoder = null;
            this.bytes = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void mark(int readlimit) {
        if (readlimit < 0) {
            throw new IllegalArgumentException("Read limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen) {
                this.readlimit = readlimit;
                this.markedIndex = this.position;
            }
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.confirmOpen();
            if (this.position >= this.totalBytes) {
                return -1;
            }
            return this.bytes[this.position++];
        }
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.confirmOpen();
            if (len == 0) {
                return 0;
            }
            if (this.position >= this.totalBytes) {
                return -1;
            }
            if (off < 0 || off > this.totalBytes || len < 0) {
                throw new IllegalArgumentException("Either one of, or both of off and len are invalid.");
            }
            int start2 = this.position + off;
            start2 = start2 < this.totalBytes ? start2 : this.totalBytes - 1;
            int end2 = start2 + len;
            end2 = end2 < this.totalBytes ? end2 : this.totalBytes - 1;
            int actuallyRead = Math.min(end2 - start2 + 1, len);
            System.arraycopy(this.bytes, start2, b2, 0, actuallyRead);
            this.position += actuallyRead;
            return actuallyRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen) {
                throw new IOException("This stream has been closed.");
            }
            if (this.markedIndex < 0) {
                throw new IOException("This stream is not marked.");
            }
            if (this.position - this.markedIndex > this.readlimit) {
                throw new IOException("Mark is invalidated.");
            }
            this.position = this.markedIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("Negarive skip");
        }
        Object object = this.lock;
        synchronized (object) {
            long skipped;
            if (!this.isOpen) {
                throw new IOException("This stream has been closed.");
            }
            if ((long)(this.totalBytes - this.position) < n) {
                skipped = this.totalBytes - this.position;
                this.position = this.totalBytes;
            } else {
                skipped = n;
                this.position = (int)((long)this.position + n);
            }
            return skipped;
        }
    }
}

