/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.OpenFile;

public class IOModule {
    public static void createIOModule(Ruby runtime, RubyModule ffi2) {
        RubyModule module = ffi2.defineModuleUnder("IO");
        module.defineAnnotatedMethods(IOModule.class);
    }

    @JRubyMethod(name={"native_read"}, module=true)
    public static final IRubyObject native_read(ThreadContext context, IRubyObject self2, IRubyObject src, IRubyObject dst, IRubyObject rbLength) {
        if (!(src instanceof RubyIO)) {
            throw context.runtime.newTypeError("wrong argument (expected IO)");
        }
        if (!(dst instanceof AbstractMemory)) {
            throw context.runtime.newTypeError("wrong argument (expected FFI memory)");
        }
        Ruby runtime = context.runtime;
        try {
            OpenFile openFile = ((RubyIO)src).getOpenFile();
            openFile.checkClosed();
            openFile.checkReadable(context);
            ByteBuffer buffer = ((AbstractMemory)dst).getMemoryIO().asByteBuffer();
            int count2 = RubyNumeric.num2int(rbLength);
            if (count2 > buffer.remaining()) {
                throw runtime.newIndexError("read count too big for output buffer");
            }
            if (count2 < buffer.remaining()) {
                buffer = buffer.duplicate();
                buffer.limit(count2);
            }
            return runtime.newFixnum(openFile.readChannel().read(buffer));
        }
        catch (EOFException e) {
            return runtime.newFixnum(-1);
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }
}

