/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.BFalseInstr;
import org.jruby.ir.instructions.BNilInstr;
import org.jruby.ir.instructions.BTrueInstr;
import org.jruby.ir.instructions.BUndefInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.instructions.TwoOperandBranchInstr;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BEQInstr
extends TwoOperandBranchInstr
implements FixedArityInstr {
    public static Instr create(Operand v1, Operand v2, Label jmpTarget) {
        if (v2 instanceof Boolean) {
            Boolean lhs = (Boolean)v2;
            if (lhs.isTrue()) {
                if (v1 instanceof Boolean) {
                    if (((Boolean)v1).isTrue()) {
                        return new JumpInstr(jmpTarget);
                    }
                    return NopInstr.NOP;
                }
                return new BTrueInstr(jmpTarget, v1);
            }
            if (lhs.isFalse()) {
                if (v1 instanceof Boolean) {
                    if (((Boolean)v1).isFalse()) {
                        return new JumpInstr(jmpTarget);
                    }
                    return NopInstr.NOP;
                }
                return new BFalseInstr(jmpTarget, v1);
            }
        } else if (v2 instanceof Nil) {
            if (v1 instanceof Nil) {
                return new JumpInstr(jmpTarget);
            }
            return new BNilInstr(jmpTarget, v1);
        }
        if (v2 == UndefinedValue.UNDEFINED) {
            if (v1 == UndefinedValue.UNDEFINED) {
                return new JumpInstr(jmpTarget);
            }
            return new BUndefInstr(jmpTarget, v1);
        }
        return new BEQInstr(jmpTarget, v1, v2);
    }

    protected BEQInstr(Label jumpTarget, Operand v1, Operand v2) {
        super(Operation.BEQ, jumpTarget, v1, v2);
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BEQInstr(ii.getRenamedLabel(this.getJumpTarget()), this.getArg1().cloneForInlining(ii), this.getArg2().cloneForInlining(ii));
    }

    public static BEQInstr decode(IRReaderDecoder d) {
        return new BEQInstr(d.decodeLabel(), d.decodeOperand(), d.decodeOperand());
    }

    @Override
    public int interpretAndGetNewIPC(ThreadContext context, DynamicScope currDynScope, StaticScope currScope, IRubyObject self2, Object[] temp, int ipc) {
        Object value2;
        Object value1 = this.getArg1().retrieve(context, self2, currScope, currDynScope, temp);
        return ((IRubyObject)value1).op_equal(context, (IRubyObject)(value2 = this.getArg2().retrieve(context, self2, currScope, currDynScope, temp))).isTrue() ? this.getJumpTarget().getTargetPC() : ipc;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BEQInstr(this);
    }
}

