/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyProc;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BuildLambdaInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr,
ClosureAcceptingInstr {
    private final String file;
    private final int line;

    public BuildLambdaInstr(Variable result2, Operand lambdaBody, String file2, int line) {
        super(Operation.LAMBDA, result2, lambdaBody);
        this.file = file2;
        this.line = line;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        scope.getFlags().add(IRFlags.BINDING_HAS_ESCAPED);
        return true;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BuildLambdaInstr(ii.getRenamedVariable(this.getResult()), this.getLambdaBody().cloneForInlining(ii), this.getFile(), this.getLine());
    }

    public Operand getLambdaBody() {
        return this.getOperand1();
    }

    @Override
    public Operand getClosureArg() {
        return this.getOperand1();
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getLambdaBody());
        e.encode(this.getFile());
        e.encode(this.getLine());
    }

    public static BuildLambdaInstr decode(IRReaderDecoder d) {
        return new BuildLambdaInstr(d.decodeVariable(), d.decodeOperand(), d.decodeString(), d.decodeInt());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        ((WrappedIRClosure)this.getLambdaBody()).getClosure().getStaticScope().determineModule();
        Block block = (Block)this.getLambdaBody().retrieve(context, self2, currScope, currDynScope, temp);
        return RubyProc.newProc(context.runtime, block, Block.Type.LAMBDA, this.getFile(), this.getLine());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuildLambdaInstr(this);
    }
}

