/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OptArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveOptArgInstr
extends ReceiveArgBase
implements FixedArityInstr {
    public final int preArgs;
    public final int requiredArgs;

    public ReceiveOptArgInstr(Variable result2, int requiredArgs, int preArgs, int optArgIndex) {
        super(Operation.RECV_OPT_ARG, result2, optArgIndex);
        this.preArgs = preArgs;
        this.requiredArgs = requiredArgs;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"index:" + this.getArgIndex(), "req: " + this.requiredArgs, "pre: " + this.preArgs};
    }

    public int getPreArgs() {
        return this.preArgs;
    }

    public int getRequiredArgs() {
        return this.requiredArgs;
    }

    @Override
    public Instr clone(CloneInfo info) {
        int optArgIndex = this.argIndex;
        if (info instanceof SimpleCloneInfo) {
            return new ReceiveOptArgInstr(info.getRenamedVariable(this.result), this.requiredArgs, this.preArgs, optArgIndex);
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        int minReqdArgs = optArgIndex + this.requiredArgs;
        if (ii.canMapArgsStatically()) {
            int n = ii.getArgsCount();
            return new CopyInstr(ii.getRenamedVariable(this.result), minReqdArgs < n ? ii.getArg(this.preArgs + optArgIndex) : UndefinedValue.UNDEFINED);
        }
        return new OptArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), ii.getArgs(), this.preArgs + optArgIndex, minReqdArgs);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.requiredArgs);
        e.encode(this.getPreArgs());
        e.encode(this.getArgIndex());
    }

    public static ReceiveOptArgInstr decode(IRReaderDecoder d) {
        return new ReceiveOptArgInstr(d.decodeVariable(), d.decodeInt(), d.decodeInt(), d.decodeInt());
    }

    @Override
    public IRubyObject receiveArg(ThreadContext context, IRubyObject[] args2, boolean acceptsKeywordArgument) {
        return IRRuntimeHelpers.receiveOptArg(args2, this.requiredArgs, this.preArgs, this.argIndex, acceptsKeywordArgument);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReceiveOptArgInstr(this);
    }
}

