/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoOperandInstr;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class TraceInstr
extends NoOperandInstr {
    private final RubyEvent event;
    private final String name;
    private final String filename;
    private final int linenumber;

    public TraceInstr(RubyEvent event2, String name2, String filename2, int linenumber) {
        super(Operation.TRACE);
        this.event = event2;
        this.name = name2;
        this.filename = filename2;
        this.linenumber = linenumber;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new TraceInstr(this.event, this.name, this.filename, this.linenumber);
    }

    public RubyEvent getEvent() {
        return this.event;
    }

    public String getName() {
        return this.name;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLinenumber() {
        return this.linenumber;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"ev: " + (Object)((Object)this.event), "name: " + this.name, "file: " + this.filename, "line: " + this.linenumber};
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getEvent());
        e.encode(this.getName());
        e.encode(this.getFilename());
        e.encode(this.getLinenumber());
    }

    public static TraceInstr decode(IRReaderDecoder d) {
        return new TraceInstr(d.decodeRubyEvent(), d.decodeString(), d.decodeString(), d.decodeInt());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        if (context.runtime.hasEventHooks()) {
            int linenumber = this.getLinenumber() == -1 ? context.getLine() + 1 : this.getLinenumber();
            context.trace(this.getEvent(), this.getName(), context.getFrameKlazz(), this.getFilename(), linenumber);
        }
        return null;
    }
}

