/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile.builtin;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Locale;
import org.jruby.runtime.profile.builtin.Invocation;
import org.jruby.runtime.profile.builtin.InvocationSet;
import org.jruby.runtime.profile.builtin.MethodData;
import org.jruby.runtime.profile.builtin.ProfileData;
import org.jruby.runtime.profile.builtin.ProfilePrinter;
import org.jruby.util.collections.IntHashMap;

public class JsonProfilePrinter
extends ProfilePrinter {
    private static Locale JSON_LOCALE = Locale.ROOT;

    public JsonProfilePrinter(ProfileData profileData) {
        super(profileData);
    }

    JsonProfilePrinter(ProfileData profileData, Invocation topInvocation) {
        super(profileData, topInvocation);
    }

    @Override
    public void printHeader(PrintStream out) {
        out.println("{\n\t\"thread_profiles\":[");
    }

    @Override
    public void printFooter(PrintStream out) {
        out.println("\n\t]\n}");
    }

    @Override
    public void printProfile(PrintStream out, boolean first2) {
        Invocation topInvocation = this.getTopInvocation();
        IntHashMap<MethodData> methods2 = JsonProfilePrinter.methodData(topInvocation);
        String threadName = this.getThreadName();
        if (!first2) {
            out.println(",");
        }
        out.println("\t\t{");
        out.printf("\t\t\t\"total_time\":%s,\n", JsonProfilePrinter.nanosToSecondsString(topInvocation.getDuration()));
        out.printf("\t\t\t\"thread_name\":\"%s\",\n", threadName);
        out.println("\t\t\t\"methods\":[");
        Iterator<MethodData> i2 = methods2.values().iterator();
        while (i2.hasNext()) {
            MethodData method = i2.next();
            out.print("\t\t\t\t");
            out.print(this.methodToJson(method));
            if (i2.hasNext()) {
                out.print(",");
            }
            out.println();
        }
        out.print("\t\t\t]\n\t\t}");
    }

    private String methodToJson(MethodData method) {
        return JsonProfilePrinter.toJsonObject("id", JsonProfilePrinter.quote(method.serialNumber), "name", JsonProfilePrinter.quote(this.methodName(method.serialNumber)), "total_calls", String.valueOf(method.totalCalls()), "total_time", JsonProfilePrinter.nanosToSecondsString(method.totalTime()), "self_time", JsonProfilePrinter.nanosToSecondsString(method.selfTime()), "child_time", JsonProfilePrinter.nanosToSecondsString(method.childTime()), "parents", this.parentCallsToJson(method), "children", this.childCallsToJson(method));
    }

    private String parentCallsToJson(MethodData method) {
        if (method.serialNumber == 0) {
            return JsonProfilePrinter.toJsonArray(new String[0]);
        }
        int[] parentSerials = method.parents();
        String[] parentCalls = new String[parentSerials.length];
        for (int i2 = 0; i2 < parentSerials.length; ++i2) {
            parentCalls[i2] = this.callToJson(parentSerials[i2], method.invocationsFromParent(parentSerials[i2]).totalCalls(), method.rootInvocationsFromParent(parentSerials[i2]));
        }
        return JsonProfilePrinter.toJsonArray(parentCalls);
    }

    private String childCallsToJson(MethodData method) {
        int[] childSerials = method.children();
        String[] childCalls = new String[childSerials.length];
        for (int i2 = 0; i2 < childSerials.length; ++i2) {
            childCalls[i2] = this.callToJson(childSerials[i2], method.invocationsOfChild(childSerials[i2]).totalCalls(), method.rootInvocationsOfChild(childSerials[i2]));
        }
        return JsonProfilePrinter.toJsonArray(childCalls);
    }

    private String callToJson(int serial, int calls, InvocationSet invocations) {
        return JsonProfilePrinter.toJsonObject("id", JsonProfilePrinter.quote(serial), "total_calls", String.valueOf(calls), "total_time", JsonProfilePrinter.nanosToSecondsString(invocations.totalTime()), "self_time", JsonProfilePrinter.nanosToSecondsString(invocations.selfTime()), "child_time", JsonProfilePrinter.nanosToSecondsString(invocations.childTime()));
    }

    private static String nanosToSecondsString(long nanos) {
        return String.format(JSON_LOCALE, "%f", (double)nanos / 1.0E9);
    }

    private static String quote(String str) {
        return String.format("\"%s\"", str);
    }

    private static String quote(int num) {
        return String.format("\"%d\"", num);
    }

    private static String toJsonArray(String ... values2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        for (String v : values2) {
            buffer.append(v);
            if (v == values2[values2.length - 1]) continue;
            buffer.append(',');
        }
        buffer.append(']');
        return buffer.toString();
    }

    private static String toJsonObject(String ... keysAndValues) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        for (int i2 = 0; i2 < keysAndValues.length; i2 += 2) {
            buffer.append(JsonProfilePrinter.quote(keysAndValues[i2]));
            buffer.append(":");
            buffer.append(keysAndValues[i2 + 1]);
            if (i2 >= keysAndValues.length - 3) continue;
            buffer.append(',');
        }
        buffer.append('}');
        return buffer.toString();
    }
}

