/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.java.JavaFunctionMessageResolution;
import com.oracle.truffle.api.interop.java.JavaFunctionObject;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class JavaObjectMessageResolution {
    JavaObjectMessageResolution() {
    }

    static abstract class WriteFieldNode
    extends Node {
        @Node.Child
        private ToJavaNode toJava = new ToJavaNode();

        WriteFieldNode() {
        }

        public Object access(VirtualFrame frame, JavaObject receiver, String name, Object value) {
            try {
                Object obj = receiver.obj;
                try {
                    Class<?> fieldType = receiver.clazz.getField(name).getType();
                    Object convertedValue = this.toJava.convert(frame, value, fieldType);
                    receiver.clazz.getField(name).set(obj, convertedValue);
                    return JavaObject.NULL;
                }
                catch (NoSuchFieldException ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }

        public Object access(JavaObject receiver, int index, Object value) {
            Object obj = receiver.obj;
            Array.set(obj, index, value);
            return JavaObject.NULL;
        }
    }

    static abstract class ReadFieldNode
    extends Node {
        ReadFieldNode() {
        }

        public Object access(JavaObject object, int index) {
            Object obj = object.obj;
            Object val = Array.get(obj, index);
            if (ToJavaNode.isPrimitive(val)) {
                return val;
            }
            return JavaInterop.asTruffleObject(val);
        }

        public Object access(JavaObject object, String name) {
            try {
                Object val;
                Object obj = object.obj;
                boolean onlyStatic = obj == null;
                try {
                    boolean isStatic;
                    Field field = object.clazz.getField(name);
                    boolean bl = isStatic = (field.getModifiers() & 8) != 0;
                    if (onlyStatic != isStatic) {
                        throw new NoSuchFieldException();
                    }
                    val = field.get(obj);
                }
                catch (NoSuchFieldException ex) {
                    for (Method m : object.clazz.getMethods()) {
                        boolean isStatic;
                        boolean bl = isStatic = (m.getModifiers() & 8) != 0;
                        if (onlyStatic != isStatic || !m.getName().equals(name)) continue;
                        return new JavaFunctionObject(m, obj);
                    }
                    throw (NoSuchFieldError)new NoSuchFieldError(ex.getMessage()).initCause(ex);
                }
                if (ToJavaNode.isPrimitive(val)) {
                    return val;
                }
                return JavaInterop.asTruffleObject(val);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    static abstract class NullCheckNode
    extends Node {
        NullCheckNode() {
        }

        public Object access(JavaObject object) {
            return object == JavaObject.NULL;
        }
    }

    static abstract class NewNode
    extends Node {
        NewNode() {
        }

        public Object access(JavaObject object, Object[] args) {
            return NewNode.execute(object, args);
        }

        private static Object execute(JavaObject receiver, Object[] args) {
            if (receiver.obj != null) {
                throw new IllegalStateException("Can only work on classes: " + receiver.obj);
            }
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof JavaObject)) continue;
                args[i] = ((JavaObject)args[i]).obj;
            }
            IllegalStateException ex = new IllegalStateException("No suitable constructor found for " + receiver.clazz);
            for (Constructor<?> constructor : receiver.clazz.getConstructors()) {
                try {
                    Object ret = constructor.newInstance(args);
                    if (ToJavaNode.isPrimitive(ret)) {
                        return ret;
                    }
                    return JavaInterop.asTruffleObject(ret);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException instEx) {
                    ex = new IllegalStateException(instEx);
                }
            }
            throw ex;
        }
    }

    static abstract class InvokeNode
    extends Node {
        @Node.Child
        private JavaFunctionMessageResolution.ExecuteNode.DoExecuteNode doExecute;

        InvokeNode() {
        }

        public Object access(VirtualFrame frame, JavaObject object, String name, Object[] args) {
            for (Method m : object.clazz.getMethods()) {
                if (!m.getName().equals(name) || m.getParameterTypes().length != args.length && !m.isVarArgs()) continue;
                if (this.doExecute == null || args.length != this.doExecute.numberOfArguments()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.doExecute = this.insert(new JavaFunctionMessageResolution.ExecuteNode.DoExecuteNode(args.length));
                }
                return this.doExecute.execute(frame, m, object.obj, args);
            }
            throw UnknownIdentifierException.raise(name);
        }
    }

    static abstract class ArrayHasSizeNode
    extends Node {
        ArrayHasSizeNode() {
        }

        public Object access(JavaObject receiver) {
            Object obj = receiver.obj;
            if (obj == null) {
                return false;
            }
            try {
                return obj instanceof Object[] || Array.getLength(obj) >= 0;
            }
            catch (IllegalArgumentException ex) {
                return Boolean.FALSE;
            }
        }
    }

    static abstract class ArrayGetSizeNode
    extends Node {
        ArrayGetSizeNode() {
        }

        public Object access(JavaObject receiver) {
            Object obj = receiver.obj;
            if (obj == null) {
                return 0;
            }
            return Array.getLength(obj);
        }
    }
}

