/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.profiles.Profile;

public abstract class LongValueProfile
extends Profile {
    LongValueProfile() {
    }

    public abstract long profile(long var1);

    public static LongValueProfile createIdentityProfile() {
        if (Profile.isProfilingEnabled()) {
            return Enabled.create();
        }
        return Disabled.INSTANCE;
    }

    static final class Disabled
    extends LongValueProfile {
        static final LongValueProfile INSTANCE = new Disabled();

        Disabled() {
        }

        @Override
        protected Object clone() {
            return INSTANCE;
        }

        @Override
        public long profile(long value) {
            return value;
        }

        public String toString() {
            return this.toStringDisabled(LongValueProfile.class);
        }
    }

    static final class Enabled
    extends LongValueProfile {
        private static final byte UNINITIALIZED = 0;
        private static final byte SPECIALIZED = 1;
        private static final byte GENERIC = 2;
        @CompilerDirectives.CompilationFinal
        private long cachedValue;
        @CompilerDirectives.CompilationFinal
        private byte state = 0;

        Enabled() {
        }

        @Override
        public long profile(long value) {
            byte localState = this.state;
            if (localState != 2) {
                long v;
                if (localState == 1 && (v = this.cachedValue) == value) {
                    return v;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (localState == 0) {
                    this.cachedValue = value;
                    this.state = 1;
                } else {
                    this.state = (byte)2;
                }
            }
            return value;
        }

        boolean isGeneric() {
            return this.state == 2;
        }

        boolean isUninitialized() {
            return this.state == 0;
        }

        long getCachedValue() {
            return this.cachedValue;
        }

        public String toString() {
            return this.toString(LongValueProfile.class, this.state == 0, this.state == 2, String.format("value == (long)%s", this.cachedValue));
        }

        static LongValueProfile create() {
            return new Enabled();
        }
    }
}

