/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.source.Source;

public final class LineLocation
implements Comparable<LineLocation> {
    private final Source source;
    private final int line;

    LineLocation(Source source, int line) {
        assert (source != null);
        this.source = source;
        this.line = line;
    }

    public Source getSource() {
        return this.source;
    }

    public int getLineNumber() {
        return this.line;
    }

    public String getShortDescription() {
        return this.source.getShortName() + ":" + this.line;
    }

    public String toString() {
        return "Line[" + this.getShortDescription() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.line;
        result = 31 * result + this.source.getHashKey().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineLocation)) {
            return false;
        }
        LineLocation other = (LineLocation)obj;
        if (this.line != other.line) {
            return false;
        }
        return this.source.getHashKey().equals(other.source.getHashKey());
    }

    @Override
    public int compareTo(LineLocation o) {
        int sourceResult = 0;
        Source thisSource = this.getSource();
        String thisPath = thisSource.getPath();
        String otherPath = o.getSource().getPath();
        if (thisPath == null || otherPath == null) {
            sourceResult = thisSource.getCode().compareTo(o.getSource().getCode());
        } else {
            String thatPath = otherPath;
            sourceResult = thisPath.compareTo(thatPath);
        }
        if (sourceResult != 0) {
            return sourceResult;
        }
        return Integer.compare(this.getLineNumber(), o.getLineNumber());
    }
}

