/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format;

import java.util.Deque;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.control.RepeatExplodedNode;
import org.jruby.truffle.core.format.control.RepeatLoopNode;
import org.jruby.truffle.core.format.control.SequenceNode;
import org.jruby.truffle.core.format.control.StarNode;
import org.jruby.truffle.core.format.pack.PackParser;

public class SharedTreeBuilder {
    private final RubyContext context;

    public SharedTreeBuilder(RubyContext context) {
        this.context = context;
    }

    public FormatNode finishSubSequence(Deque<List<FormatNode>> sequenceStack, PackParser.SubSequenceContext ctx) {
        List<FormatNode> sequence = sequenceStack.pop();
        SequenceNode sequenceNode = new SequenceNode(this.context, sequence.toArray(new FormatNode[sequence.size()]));
        if (ctx.INT() == null) {
            return sequenceNode;
        }
        return this.createRepeatNode(Integer.parseInt(ctx.INT().getText()), sequenceNode);
    }

    public FormatNode applyCount(PackParser.CountContext count, FormatNode node) {
        if (count == null) {
            return node;
        }
        if (count.INT() != null) {
            return this.createRepeatNode(Integer.parseInt(count.INT().getText()), node);
        }
        return new StarNode(this.context, node);
    }

    private FormatNode createRepeatNode(int count, FormatNode node) {
        if (count > this.context.getOptions().PACK_UNROLL_LIMIT) {
            return new RepeatLoopNode(this.context, count, node);
        }
        return new RepeatExplodedNode(this.context, count, node);
    }

    public StarLength parseCountContext(PackParser.CountContext ctx) {
        int length;
        boolean star;
        if (ctx == null) {
            star = false;
            length = 1;
        } else if (ctx.INT() == null) {
            star = true;
            length = 0;
        } else {
            star = false;
            length = Integer.parseInt(ctx.INT().getText());
        }
        return new StarLength(star, length);
    }

    public static class StarLength {
        private final boolean star;
        private final int length;

        public StarLength(boolean star, int length) {
            this.star = star;
            this.length = length;
        }

        public boolean isStar() {
            return this.star;
        }

        public int getLength() {
            return this.length;
        }
    }
}

