/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.convert;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.MissingValue;

@NodeChildren(value={@NodeChild(value="bytes", type=FormatNode.class)})
public abstract class BytesToInteger64LittleNode
extends FormatNode {
    public BytesToInteger64LittleNode(RubyContext context) {
        super(context);
    }

    @Specialization
    public MissingValue decode(MissingValue missingValue) {
        return missingValue;
    }

    @Specialization(guards={"isNil(nil)"})
    public DynamicObject decode(DynamicObject nil) {
        return nil;
    }

    @Specialization
    public long decode(byte[] bytes) {
        long value = 0L;
        value |= (long)(bytes[7] & 0xFF) << 56;
        value |= (long)(bytes[6] & 0xFF) << 48;
        value |= (long)(bytes[5] & 0xFF) << 40;
        value |= (long)(bytes[4] & 0xFF) << 32;
        value |= (long)(bytes[3] & 0xFF) << 24;
        value |= (long)(bytes[2] & 0xFF) << 16;
        value |= (long)(bytes[1] & 0xFF) << 8;
        return value |= (long)(bytes[0] & 0xFF);
    }
}

