/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.write.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.MissingValue;
import org.jruby.truffle.core.format.write.OutputNode;

@NodeChildren(value={@NodeChild(value="output", type=OutputNode.class), @NodeChild(value="value", type=Node.class)})
public abstract class WriteValueNode
extends FormatNode {
    public WriteValueNode(RubyContext context) {
        super(context);
    }

    @Specialization
    public Object doWrite(Object output, MissingValue value) {
        return null;
    }

    @Specialization(guards={"!isMissingValue(value)"})
    public Object doWrite(VirtualFrame frame, Object[] output, Object value) {
        Object[] outputWithEnoughSize = this.ensureCapacity(frame, output, 1);
        int outputPosition = this.getOutputPosition(frame);
        outputWithEnoughSize[outputPosition] = value;
        this.setOutputPosition(frame, outputPosition + 1);
        return null;
    }

    private Object[] ensureCapacity(VirtualFrame frame, Object[] output, int length) {
        int outputPosition = this.getOutputPosition(frame);
        int neededLength = outputPosition + length;
        if (neededLength <= output.length) {
            return output;
        }
        CompilerDirectives.transferToInterpreter();
        Object[] newOutput = new Object[ArrayUtils.capacity(this.getContext(), output.length, neededLength)];
        System.arraycopy(output, 0, newOutput, 0, outputPosition);
        this.setOutput(frame, newOutput);
        return newOutput;
    }
}

